/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model;

import com.abiquo.event.model.details.ErrorDetails;
import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.details.MessageDetails;
import com.abiquo.event.model.details.MoveDetails;
import com.abiquo.event.model.details.ReconfigureDetails;
import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class EventAdapter {

    private static class MapEntry {
        @XmlAttribute
        public String key;
        @XmlValue
        public Object value;

        private MapEntry() {
        }
    }

    private static class MapType {
        @XmlElement(name="detail")
        public List<MapEntry> entryList = new ArrayList<MapEntry>();

        private MapType() {
        }
    }

    public static class OptionalMapAdapter
    extends XmlAdapter<MapType, Optional<? extends EventDetails>> {
        public MapType marshal(Optional<? extends EventDetails> details) {
            Map map = details.isPresent() ? (Map)details.get() : new HashMap();
            MapType mapType = new MapType();
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = new MapEntry();
                mapEntry.key = ((AbiquoKey)entry.getKey()).name();
                mapEntry.value = entry.getValue();
                mapType.entryList.add(mapEntry);
            }
            return mapType;
        }

        public Optional<? extends EventDetails> unmarshal(MapType type) throws Exception {
            if (type.entryList.isEmpty()) {
                return Optional.absent();
            }
            return this.getDetails(type);
        }

        private Optional<? extends EventDetails> getDetails(MapType type) {
            boolean isError = Boolean.FALSE;
            boolean isMove = Boolean.FALSE;
            boolean isReconfigure = Boolean.FALSE;
            String scope = null;
            String code = null;
            String message = null;
            String targetUri = null;
            for (MapEntry thisEntry : type.entryList) {
                String key = thisEntry.key;
                if (key.equals(ErrorDetails.KEYS.SCOPE.name())) {
                    isError = Boolean.TRUE;
                    scope = String.valueOf(thisEntry.value);
                    continue;
                }
                if (key.equals(ErrorDetails.KEYS.MESSAGE.name())) {
                    message = String.valueOf(thisEntry.value);
                    continue;
                }
                if (key.equals(ErrorDetails.KEYS.CODE.name())) {
                    code = String.valueOf(thisEntry.value);
                    continue;
                }
                if (key.equals(MoveDetails.KEYS.TARGETURI.name())) {
                    isMove = Boolean.TRUE;
                    targetUri = String.valueOf(thisEntry.value);
                    continue;
                }
                if (!key.equals(ReconfigureDetails.keys.CPU.name()) && !key.equals(ReconfigureDetails.keys.RAM.name())) continue;
                isReconfigure = Boolean.TRUE;
            }
            if (isError) {
                return this.getOptional(type, ErrorDetails.builder(code, message, scope));
            }
            if (isMove) {
                return this.getOptional(type, MoveDetails.builder(targetUri));
            }
            if (isReconfigure) {
                return this.getOptional(type, ReconfigureDetails.builder());
            }
            return this.getOptional(type, MessageDetails.builder());
        }

        private Optional<? extends EventDetails> getOptional(MapType type, EventDetails.Builder<?, ? extends EventDetails> b) {
            for (final MapEntry entry : type.entryList) {
                AbiquoKey key = new AbiquoKey(){

                    @Override
                    public String name() {
                        return entry.key;
                    }
                };
                if (entry.value instanceof Collection) {
                    b.put(key, (Collection)entry.value);
                    continue;
                }
                b.put(key, String.valueOf(entry.value));
            }
            return Optional.of((Object)b.build());
        }
    }

    public static class OptionalStringAdapter
    extends XmlAdapter<String, Optional<String>> {
        public String marshal(Optional<String> optional) throws Exception {
            return (String)optional.or((Object)"");
        }

        public Optional<String> unmarshal(String optional) throws Exception {
            return Optional.fromNullable((Object)Strings.emptyToNull((String)optional));
        }
    }
}

