/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model.details;

import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.enumerations.ErrorScope;
import com.abiquo.event.model.interfaces.AbiquoError;
import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ErrorDetails
extends EventDetails {
    protected ErrorDetails(ImmutableMap<AbiquoKey, Object> map) {
        super(map);
    }

    public String getCode() {
        return String.valueOf(this.get(KEYS.CODE));
    }

    public String getMessage() {
        return String.valueOf(this.get(KEYS.MESSAGE));
    }

    public String getScope() {
        return String.valueOf(this.get(KEYS.SCOPE));
    }

    public String getStacktrace() {
        return String.valueOf(this.get(KEYS.STACKTRACE));
    }

    public static Builder<?, ErrorDetails> builder(AbiquoError error, ErrorScope scope) {
        return new Builder(error, scope);
    }

    public static Builder<?, ErrorDetails> builder(List<AbiquoError> errors, ErrorScope scope) {
        return new Builder(errors, scope);
    }

    public static Builder<?, ErrorDetails> builder(List<AbiquoError> errors, ErrorScope scope, Throwable stacktrace) {
        return new Builder(errors, scope, stacktrace);
    }

    public static Builder<?, ErrorDetails> builder(AbiquoError error, ErrorScope scope, Throwable stacktrace) {
        return new Builder(error, scope, stacktrace);
    }

    static Builder<?, ErrorDetails> builder() {
        return new Builder();
    }

    public static Builder<?, ErrorDetails> builder(String code, String message, String scope) {
        return new Builder(code, scope, message);
    }

    public static String getFormattedStracktrace(Throwable throwable) {
        StringBuilder stack = new StringBuilder("");
        if (throwable.getStackTrace() != null) {
            for (StackTraceElement e : throwable.getStackTrace()) {
                stack.append(e.toString());
            }
        }
        return stack.toString();
    }

    public static class Builder<B extends Builder<B, E>, E extends ErrorDetails>
    extends EventDetails.Builder<B, E> {
        @Override
        public E build() {
            return (E)new ErrorDetails((ImmutableMap<AbiquoKey, Object>)this.mapBuilder.build());
        }

        @Override
        protected B self() {
            return (B)this;
        }

        protected Builder(AbiquoError error, ErrorScope scope) {
            this.mapBuilder.put((Object)KEYS.CODE, (Object)error.getCode());
            this.mapBuilder.put((Object)KEYS.MESSAGE, (Object)error.getMessage());
            this.mapBuilder.put((Object)KEYS.SCOPE, (Object)scope.name());
        }

        protected Builder(List<AbiquoError> errors, ErrorScope scope) {
            this.mapBuilder.put((Object)KEYS.CODE, (Object)Joiner.on((char)',').join(Iterables.transform(errors, (Function)new Function<AbiquoError, String>(){

                public String apply(AbiquoError input) {
                    return input.getCode();
                }
            })));
            this.mapBuilder.put((Object)KEYS.MESSAGE, (Object)Joiner.on((char)'\n').join(Iterables.transform(errors, (Function)new Function<AbiquoError, String>(){

                public String apply(AbiquoError input) {
                    return input.getMessage();
                }
            })));
            this.mapBuilder.put((Object)KEYS.SCOPE, (Object)scope.name());
        }

        protected Builder(AbiquoError error, ErrorScope scope, Throwable throwable) {
            this(error, scope);
            this.mapBuilder.put((Object)KEYS.STACKTRACE, (Object)ErrorDetails.getFormattedStracktrace(throwable));
            this.mapBuilder.put((Object)KEYS.ERROR_MESSAGE, (Object)(throwable.getMessage() != null ? throwable.getMessage() : ""));
        }

        protected Builder(List<AbiquoError> errors, ErrorScope scope, Throwable throwable) {
            this(errors, scope);
            this.mapBuilder.put((Object)KEYS.STACKTRACE, (Object)ErrorDetails.getFormattedStracktrace(throwable));
            this.mapBuilder.put((Object)KEYS.ERROR_MESSAGE, (Object)(throwable.getMessage() != null ? throwable.getMessage() : ""));
        }

        public B stacktrace(String stacktrace) {
            this.mapBuilder.put((Object)KEYS.STACKTRACE, (Object)stacktrace);
            return (B)this.self();
        }

        public B code(String code) {
            this.mapBuilder.put((Object)KEYS.CODE, (Object)code);
            return (B)this.self();
        }

        public B error(AbiquoError error) {
            this.mapBuilder.put((Object)KEYS.CODE, (Object)error.getCode());
            this.mapBuilder.put((Object)KEYS.MESSAGE, (Object)error.getMessage());
            return (B)this.self();
        }

        public B message(String message) {
            this.mapBuilder.put((Object)KEYS.MESSAGE, (Object)message);
            return (B)this.self();
        }

        public B scope(String scope) {
            this.mapBuilder.put((Object)KEYS.SCOPE, (Object)scope);
            return (B)this.self();
        }

        public Builder(String code, String scope, String message) {
            this.mapBuilder.put((Object)KEYS.CODE, (Object)code);
            this.mapBuilder.put((Object)KEYS.MESSAGE, (Object)message);
            this.mapBuilder.put((Object)KEYS.SCOPE, (Object)scope);
        }

        public Builder() {
        }
    }

    public static enum KEYS implements AbiquoKey
    {
        CODE,
        MESSAGE,
        SCOPE,
        STACKTRACE,
        ERROR_MESSAGE;

    }
}

