/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model.details;

import com.abiquo.event.model.details.ErrorDetails;
import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.details.MessageDetails;
import com.abiquo.event.model.details.MoveDetails;
import com.abiquo.event.model.details.ReconfigureDetails;
import com.abiquo.event.model.interfaces.AbiquoKey;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventDetailsDeserializer
extends JsonDeserializer<EventDetails> {
    private static final Function<JsonNode, String> jsonNodeAsText = new Function<JsonNode, String>(){

        public String apply(JsonNode input) {
            return input.asText();
        }
    };

    public EventDetails deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        return EventDetailsDeserializer.getDetails(node);
    }

    private static EventDetails getDetails(JsonNode node) {
        EventDetails.Builder<EventDetails.Builder<?, EventDetails>, EventDetails> builder = EventDetailsDeserializer.getDetailsBuilder((List<String>)ImmutableList.copyOf((Iterator)node.fieldNames()));
        ImmutableMap.Builder<AbiquoKey, Object> mapBuilder = EventDetailsDeserializer.createMap(node.fields());
        return builder.messageArgs((Map<AbiquoKey, Object>)mapBuilder.build()).build();
    }

    private static ImmutableMap.Builder<AbiquoKey, Object> createMap(Iterator<Map.Entry<String, JsonNode>> fields) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        while (fields.hasNext()) {
            final Map.Entry<String, JsonNode> entry = fields.next();
            mapBuilder.put((Object)new AbiquoKey(){
                private final String name;
                {
                    this.name = (String)entry.getKey();
                }

                @Override
                public String name() {
                    return this.name;
                }

                public String toString() {
                    return this.name();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof AbiquoKey) {
                        return Objects.equals(this.name, ((AbiquoKey)obj).name());
                    }
                    return false;
                }
            }, entry.getValue().isArray() ? Lists.newArrayList((Iterator)Iterators.transform((Iterator)entry.getValue().elements(), jsonNodeAsText)) : entry.getValue().asText());
        }
        return mapBuilder;
    }

    private static EventDetails.Builder<? extends EventDetails.Builder<?, ? extends EventDetails>, ? extends EventDetails> getDetailsBuilder(List<String> keys2) {
        if (keys2.contains(ErrorDetails.KEYS.SCOPE.name()) || keys2.contains(ErrorDetails.KEYS.MESSAGE.name()) || keys2.contains(ErrorDetails.KEYS.CODE.name())) {
            return ErrorDetails.builder();
        }
        if (keys2.contains(MoveDetails.KEYS.TARGETURI.name())) {
            return MoveDetails.builder();
        }
        if (keys2.contains(ReconfigureDetails.keys.CPU.name()) || keys2.contains(ReconfigureDetails.keys.RAM.name())) {
            return ReconfigureDetails.builder();
        }
        return MessageDetails.builder();
    }
}

