/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model.details;

import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ReconfigureDetails
extends EventDetails {
    public static String ENABLED_VALUE = "+";
    public static String DISABLED_VALUE = "-";

    protected ReconfigureDetails(ImmutableMap<AbiquoKey, Object> map) {
        super(map);
    }

    public String getCpuDiff() {
        return String.valueOf(this.get(keys.CPU));
    }

    public String getRamDiff() {
        return String.valueOf(this.get(keys.RAM));
    }

    public String getCoresPerSocketDiff() {
        return String.valueOf(this.get(keys.CORES_PER_SOCKET));
    }

    public String getDvdDiff() {
        return String.valueOf(this.get(keys.DVD));
    }

    public String getRemoteAccessDiff() {
        return String.valueOf(this.get(keys.REMOTE_ACCESS));
    }

    public static Builder<?, ReconfigureDetails> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B, E>, E extends ReconfigureDetails>
    extends EventDetails.Builder<B, E> {
        protected Builder() {
            this.mapBuilder = ImmutableMap.builder();
        }

        public B cpuDiff(String cpuDiff) {
            this.mapBuilder.put((Object)keys.CPU, (Object)cpuDiff);
            return (B)this.self();
        }

        public B ramDiff(String ramDiff) {
            this.mapBuilder.put((Object)keys.RAM, (Object)ramDiff);
            return (B)this.self();
        }

        public B coresPerSocketDiff(String coresPerSocketDiff) {
            this.mapBuilder.put((Object)keys.CORES_PER_SOCKET, (Object)coresPerSocketDiff);
            return (B)this.self();
        }

        public B dvdDiff(String dvdDiff) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dvdDiff) ? 1 : 0) != 0, (Object)"dvdDiff can not be null or empty");
            Preconditions.checkArgument((ENABLED_VALUE.equals(dvdDiff) || DISABLED_VALUE.equals(dvdDiff) ? 1 : 0) != 0, (Object)"Invalid value for dvd diff");
            this.mapBuilder.put((Object)keys.DVD, (Object)dvdDiff);
            return (B)this.self();
        }

        public B remoteAccessDiff(String remoteAccessDiff) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)remoteAccessDiff) ? 1 : 0) != 0, (Object)"dvdremoteAccessDiff can not be null or empty");
            Preconditions.checkArgument((ENABLED_VALUE.equals(remoteAccessDiff) || DISABLED_VALUE.equals(remoteAccessDiff) ? 1 : 0) != 0, (Object)"Invalid value for remote access diff");
            this.mapBuilder.put((Object)keys.REMOTE_ACCESS, (Object)remoteAccessDiff);
            return (B)this.self();
        }

        @Override
        public E build() {
            return (E)new ReconfigureDetails((ImmutableMap<AbiquoKey, Object>)this.mapBuilder.build());
        }

        @Override
        protected B self() {
            return (B)this;
        }
    }

    public static enum keys implements AbiquoKey
    {
        CPU,
        RAM,
        CORES_PER_SOCKET,
        DVD,
        REMOTE_ACCESS;

    }
}

