/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model.enumerations;

import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Field;

public final class EntityAction {
    private static LoadingCache<Class<?>, Class<?>[]> innerClassCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Class<?>[]>(){

        public Class<?>[] load(Class<?> key) throws Exception {
            return key.getClasses();
        }
    });
    private static LoadingCache<Class<?>, Field[]> fieldCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Field[]>(){

        public Field[] load(Class<?> key) throws Exception {
            return key.getFields();
        }
    });

    public static Optional<Action> tryBuildFrom(String entity, String action) {
        Class[] classes;
        for (Class clazz : classes = (Class[])innerClassCache.getUnchecked(EntityAction.class)) {
            Field[] actions;
            if (!entity.equalsIgnoreCase(clazz.getSimpleName())) continue;
            for (Field field : actions = (Field[])fieldCache.getUnchecked((Object)clazz)) {
                if (!action.equalsIgnoreCase(field.getName())) continue;
                try {
                    return Optional.of((Object)((Action)field.get(new Action(clazz, null, null, null, null))));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return Optional.absent();
                }
            }
        }
        return Optional.absent();
    }

    public static class Action<E> {
        private final String parent;
        private final String name;
        private final KEYS[] infokeys;
        private final KEYS[] warnkeys;
        private KEYS[] errorkeys;

        private Action(Class<E> clazz, String name, KEYS[] infokeys, KEYS[] warnkeys, KEYS[] errorkeys) {
            this.name = name;
            this.parent = clazz.getSimpleName();
            this.infokeys = infokeys;
            this.warnkeys = warnkeys;
            this.errorkeys = errorkeys;
        }

        public String action() {
            return this.name;
        }

        public String entity() {
            return this.parent;
        }

        public KEYS[] getInfokeys() {
            return this.infokeys;
        }

        public KEYS[] getWarnkeys() {
            return this.warnkeys;
        }

        public KEYS[] getErrorkeys() {
            return this.errorkeys;
        }

        public Action<E> addErrorkeys(KEYS[] keys2) {
            this.errorkeys = (KEYS[])ObjectArrays.concat((Object[])this.errorkeys, (Object[])keys2, KEYS.class);
            return this;
        }

        public String toPerformedAction() {
            return String.format("%s_%s", this.entity(), this.action());
        }
    }

    public static final class BILL_REGISTER {
        public static final Action<BILL_REGISTER> CREATE = new Action(BILL_REGISTER.class, "CREATE", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BILL_REGISTER> DELETE = new Action(BILL_REGISTER.class, "DELETE", new KEYS[]{KEYS.ENT_NAME, KEYS.BILL_PERIOD_START, KEYS.BILL_PERIOD_END, KEYS.BILL_PROVIDER, KEYS.BILL_DATE}, new KEYS[0], new KEYS[0]);
    }

    public static final class BILL {
        public static final Action<BILL> CREATE = new Action(BILL.class, "CREATE", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BILL> DELETE = new Action(BILL.class, "DELETE", new KEYS[]{KEYS.ENT_NAME, KEYS.BILL_PERIOD_START, KEYS.BILL_PERIOD_END, KEYS.BILL_PROVIDER}, new KEYS[0], new KEYS[0]);
    }

    public static final class EXCLUDED_NETWORK {
        public static final Action<EXCLUDED_NETWORK> CREATE = new Action(EXCLUDED_NETWORK.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<EXCLUDED_NETWORK> DELETE = new Action(EXCLUDED_NETWORK.class, "DELETE", new KEYS[]{KEYS.EXCLUDED_NET_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXCLUDED_NETWORK> MODIFY = new Action(EXCLUDED_NETWORK.class, "MODIFY", new KEYS[]{KEYS.EXCLUDED_NET_OLD_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class ACTION_PLAN {
        public static final Action<ACTION_PLAN> CREATE = new Action(ACTION_PLAN.class, "CREATE", new KEYS[]{KEYS.ACTION_PLAN_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ACTION_PLAN> DELETE = new Action(ACTION_PLAN.class, "DELETE", new KEYS[]{KEYS.ACTION_PLAN_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ACTION_PLAN> MODIFY = new Action(ACTION_PLAN.class, "MODIFY", new KEYS[]{KEYS.ACTION_PLAN_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ACTION_PLAN> START_EXECUTION = new Action(ACTION_PLAN.class, "START_EXECUTION", new KEYS[]{KEYS.ACTION_PLAN_NAME, KEYS.ACTION_PLAN_EXECUTION_INITIATOR}, new KEYS[0], new KEYS[]{KEYS.ACTION_PLAN_NAME});
        public static final Action<ACTION_PLAN> FINISH_EXECUTION = new Action(ACTION_PLAN.class, "FINISH_EXECUTION", new KEYS[]{KEYS.ACTION_PLAN_NAME}, new KEYS[0], new KEYS[]{KEYS.ACTION_PLAN_NAME});
    }

    public static final class BACKUP_MANAGER {
        public static final Action<BACKUP_MANAGER> CREATE = new Action(BACKUP_MANAGER.class, "CREATE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_MANAGER> MODIFY = new Action(BACKUP_MANAGER.class, "MODIFY", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_MANAGER> DELETE = new Action(BACKUP_MANAGER.class, "DELETE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class HARDWARE_PROFILE {
        public static final Action<HARDWARE_PROFILE> ALLOW = new Action(HARDWARE_PROFILE.class, "ALLOW", new KEYS[]{KEYS.HP_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARDWARE_PROFILE> RESTRICT = new Action(HARDWARE_PROFILE.class, "RESTRICT", new KEYS[]{KEYS.HP_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class HARDWARE_PROFILE_PUBLIC_CLOUD_REGION {
        public static final Action<HARDWARE_PROFILE_PUBLIC_CLOUD_REGION> CREATE = new Action(HARDWARE_PROFILE_PUBLIC_CLOUD_REGION.class, "CREATE", new KEYS[]{KEYS.PCR_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARDWARE_PROFILE_PUBLIC_CLOUD_REGION> MODIFY = new Action(HARDWARE_PROFILE_PUBLIC_CLOUD_REGION.class, "MODIFY", new KEYS[]{KEYS.HP_ABS_DC_OLD_NAME, KEYS.PCR_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARDWARE_PROFILE_PUBLIC_CLOUD_REGION> DELETE = new Action(HARDWARE_PROFILE_PUBLIC_CLOUD_REGION.class, "DELETE", new KEYS[]{KEYS.HP_ABS_DC_NAME, KEYS.PCR_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class HARDWARE_PROFILE_DATACENTER {
        public static final Action<HARDWARE_PROFILE_DATACENTER> CREATE = new Action(HARDWARE_PROFILE_DATACENTER.class, "CREATE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARDWARE_PROFILE_DATACENTER> MODIFY = new Action(HARDWARE_PROFILE_DATACENTER.class, "MODIFY", new KEYS[]{KEYS.HP_ABS_DC_OLD_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARDWARE_PROFILE_DATACENTER> DELETE = new Action(HARDWARE_PROFILE_DATACENTER.class, "DELETE", new KEYS[]{KEYS.HP_ABS_DC_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class SCALING_GROUP {
        public static final Action<SCALING_GROUP> CREATE = new Action(SCALING_GROUP.class, "CREATE", new KEYS[]{KEYS.VAPP_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> DELETE = new Action(SCALING_GROUP.class, "DELETE", new KEYS[]{KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> MODIFY = new Action(SCALING_GROUP.class, "MODIFY", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> START_MAINTENANCE = new Action(SCALING_GROUP.class, "START_MAINTENANCE", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> END_MAINTENANCE = new Action(SCALING_GROUP.class, "END_MAINTENANCE", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> SCALE_OUT = new Action(SCALING_GROUP.class, "SCALE_OUT", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> SCALE_IN = new Action(SCALING_GROUP.class, "SCALE_IN", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> CAPACITY_ADJUSTED = new Action(SCALING_GROUP.class, "CAPACITY_ADJUSTED", new KEYS[]{KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME, KEYS.SCALING_GROUP_ADJUSTMENT}, new KEYS[0], new KEYS[0]);
        public static final Action<SCALING_GROUP> UNABLE_TO_CLONE_MASTER_VM = new Action(SCALING_GROUP.class, "UNABLE_TO_CLONE_MASTER_VM", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME});
        public static final Action<SCALING_GROUP> UNABLE_TO_DEPLOY_CLONED_VM = new Action(SCALING_GROUP.class, "UNABLE_TO_DEPLOY_CLONED_VM", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME});
        public static final Action<SCALING_GROUP> UNABLE_TO_UNDEPLOY_VM = new Action(SCALING_GROUP.class, "UNABLE_TO_UNDEPLOY_VM", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME});
        public static final Action<SCALING_GROUP> MOVE_TO_VAPP = new Action(SCALING_GROUP.class, "MOVE_TO_VAPP", new KEYS[]{KEYS.SCALING_GROUP_NAME, KEYS.VAPP_NAME, KEYS.VAPP_MOVED_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class ALERT {
        public static final Action<ALERT> CREATE = new Action(ALERT.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<ALERT> DELETE = new Action(ALERT.class, "DELETE", new KEYS[]{KEYS.ALERT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ALERT> MODIFY = new Action(ALERT.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<ALERT> ACTIVE = new Action(ALERT.class, "ACTIVE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<ALERT> INACTIVE = new Action(ALERT.class, "INACTIVE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class ALARM {
        public static final Action<ALARM> CREATE = new Action(ALARM.class, "CREATE", new KEYS[]{KEYS.ENTITY_TYPE, KEYS.ENTITY_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ALARM> DELETE = new Action(ALARM.class, "DELETE", new KEYS[]{KEYS.ENTITY_TYPE, KEYS.ALARM_NAME, KEYS.ENTITY_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ALARM> MODIFY = new Action(ALARM.class, "MODIFY", new KEYS[]{KEYS.ENTITY_TYPE, KEYS.ENTITY_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class VIRTUAL_APPLIANCE_SPEC {
        public static final Action<VIRTUAL_APPLIANCE_SPEC> CREATE = new Action(VIRTUAL_APPLIANCE_SPEC.class, "CREATE", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> CREATE_VERSION = new Action(VIRTUAL_APPLIANCE_SPEC.class, "CREATE_VERSION", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> SET_DEFAULT = new Action(VIRTUAL_APPLIANCE_SPEC.class, "SET_DEFAULT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> DELETE = new Action(VIRTUAL_APPLIANCE_SPEC.class, "DELETE", new KEYS[]{KEYS.SPEC_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> DELETE_SPECS = new Action(VIRTUAL_APPLIANCE_SPEC.class, "DELETE_SPECS", new KEYS[]{KEYS.SPEC_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> MODIFY = new Action(VIRTUAL_APPLIANCE_SPEC.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE_SPEC> MATERIALIZE = new Action(VIRTUAL_APPLIANCE_SPEC.class, "MATERIALIZE", new KEYS[]{KEYS.TASK_TYPE, KEYS.VAPP_NAME}, new KEYS[0], new KEYS[]{KEYS.TASK_TYPE, KEYS.JOB_TYPE, KEYS.TASK_ERROR, KEYS.VAPP_NAME});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_PRIVATE_NETWORK = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_PRIVATE_NETWORK", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.PRIVATE_NET_ID, KEYS.VDC_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_EXTERNAL_NETWORK = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_EXTERNAL_NETWORK", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.EXTERNAL_NET_ID, KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_PUBLIC_IP = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_PUBLIC_IP", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.IP, KEYS.VDC_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_FLOATING_IP = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_FLOATING_IP", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.IP, KEYS.VDC_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_FIREWALL = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_FIREWALL", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.FIREWALL_ID, KEYS.VDC_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_LOAD_BALANCER = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_LOAD_BALANCER", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.LOAD_BALANCER_ID, KEYS.VDC_NAME, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_VOLUME = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_VOLUME", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VOLUME_ID, KEYS.VDC_NAME});
        public static final Action<VIRTUAL_APPLIANCE_SPEC> ROLLBACK_VIRTUAL_MACHINE = new Action(VIRTUAL_APPLIANCE_SPEC.class, "ROLLBACK_VIRTUAL_MACHINE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_ID, KEYS.VAPP_NAME, KEYS.VDC_NAME, KEYS.TASK_ERROR});
    }

    public static final class VPN_IPSEC {
        public static final Action<VPN_IPSEC> CREATE = new Action(VPN_IPSEC.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VPN_IPSEC> UPDATE = new Action(VPN_IPSEC.class, "UPDATE", new KEYS[]{KEYS.VPN_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VPN_IPSEC> DELETE = new Action(VPN_IPSEC.class, "DELETE", new KEYS[]{KEYS.VPN_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class HEALTH_CHECK {
        public static final Action<HEALTH_CHECK> CREATE = new Action(HEALTH_CHECK.class, "CREATE", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HEALTH_CHECK> DELETE = new Action(HEALTH_CHECK.class, "DELETE", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.LOAD_BALANCER_NAME, KEYS.HEALTH_CHECK_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HEALTH_CHECK> MODIFY = new Action(HEALTH_CHECK.class, "MODIFY", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class SSL_CERTIFICATE {
        public static final Action<SSL_CERTIFICATE> CREATE = new Action(SSL_CERTIFICATE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class ROUTING_RULE {
        public static final Action<ROUTING_RULE> CREATE = new Action(ROUTING_RULE.class, "CREATE", new KEYS[]{KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ROUTING_RULE> MODIFY = new Action(ROUTING_RULE.class, "MODIFY", new KEYS[]{KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ROUTING_RULE> DELETE = new Action(ROUTING_RULE.class, "DELETE", new KEYS[]{KEYS.ROUTING_RULE_PORT_IN, KEYS.ROUTING_RULE_PORT_OUT, KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class LOAD_BALANCER_ADDRESS {
        public static final Action<LOAD_BALANCER_ADDRESS> CREATE = new Action(LOAD_BALANCER_ADDRESS.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER_ADDRESS> DELETE = new Action(LOAD_BALANCER_ADDRESS.class, "DELETE", new KEYS[]{KEYS.LOAD_BALANCER_ADDRESS_PROVIDERID, KEYS.LOAD_BALANCER_ADDRESS_ENDPOINT}, new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER_ADDRESS> MODIFY = new Action(LOAD_BALANCER_ADDRESS.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class LOAD_BALANCER {
        public static final Action<LOAD_BALANCER> CREATE = new Action(LOAD_BALANCER.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> DELETE = new Action(LOAD_BALANCER.class, "DELETE", new KEYS[]{KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> MODIFY = new Action(LOAD_BALANCER.class, "MODIFY", new KEYS[]{KEYS.LOAD_BALANCER_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> VIRTUAL_MACHINES = new Action(LOAD_BALANCER.class, "VIRTUAL_MACHINES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.LOAD_BALANCER_NAME});
        public static final Action<LOAD_BALANCER> SYNCH_CREATE = new Action(LOAD_BALANCER.class, "SYNCH_CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> SYNCH_DELETE = new Action(LOAD_BALANCER.class, "SYNCH_DELETE", new KEYS[]{KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[]{KEYS.LOAD_BALANCER_NAME});
        public static final Action<LOAD_BALANCER> SYNCH_MODIFY = new Action(LOAD_BALANCER.class, "SYNCH_MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> SYNCH_VIRTUAL_MACHINES = new Action(LOAD_BALANCER.class, "SYNCH_VIRTUAL_MACHINES", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<LOAD_BALANCER> SYNCH_VIRTUAL_MACHINES_DELETE = new Action(LOAD_BALANCER.class, "SYNCH_VIRTUAL_MACHINES_DELETE", new KEYS[]{KEYS.LOAD_BALANCER_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class FIREWALL_POLICY {
        public static final Action<FIREWALL_POLICY> CREATE = new Action(FIREWALL_POLICY.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<FIREWALL_POLICY> MODIFY = new Action(FIREWALL_POLICY.class, "MODIFY", new KEYS[]{KEYS.POLICY_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<FIREWALL_POLICY> DELETE = new Action(FIREWALL_POLICY.class, "DELETE", new KEYS[]{KEYS.POLICY_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<FIREWALL_POLICY> RULES_MODIFY = new Action(FIREWALL_POLICY.class, "RULES_MODIFY", new KEYS[]{KEYS.POLICY_NAME}, new KEYS[]{KEYS.POLICY_NAME}, new KEYS[0]);
        public static final Action<FIREWALL_POLICY> RULES_RESTORE = new Action(FIREWALL_POLICY.class, "RULES_RESTORE", new KEYS[]{KEYS.POLICY_NAME}, new KEYS[]{KEYS.POLICY_NAME}, new KEYS[0]);
        public static final Action<FIREWALL_POLICY> VIRTUAL_MACHINES = new Action(FIREWALL_POLICY.class, "VIRTUAL_MACHINES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.FIREWALL_NAME});
    }

    public static final class DEVICE {
        public static final Action<DEVICE> CREATE = new Action(DEVICE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class APPLICATION {
        public static final Action<APPLICATION> CREATE = new Action(APPLICATION.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<APPLICATION> DELETE = new Action(APPLICATION.class, "DELETE", new KEYS[]{KEYS.APPLICATION_NAME, KEYS.USER_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class PUBLIC_CLOUD_REGION {
        public static final Action<PUBLIC_CLOUD_REGION> CREATE = new Action(PUBLIC_CLOUD_REGION.class, "CREATE", new KEYS[]{KEYS.PCR_REGION, KEYS.PCR_ENDPOINT}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> MODIFY = new Action(PUBLIC_CLOUD_REGION.class, "MODIFY", new KEYS[]{KEYS.PCR_NAME, KEYS.PCR_ENDPOINT, KEYS.PCR_OLD_NAME, KEYS.PCR_OLD_ENDPOINT}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> DELETE = new Action(PUBLIC_CLOUD_REGION.class, "DELETE", new KEYS[]{KEYS.PCR_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> REMOTE_SERVICES_CREATE = new Action(PUBLIC_CLOUD_REGION.class, "REMOTE_SERVICES_CREATE", new KEYS[0], new KEYS[]{KEYS.RS_ERROR}, new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> SYNC_START = new Action(PUBLIC_CLOUD_REGION.class, "SYNC_START", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> SYNC_FINISHED = new Action(PUBLIC_CLOUD_REGION.class, "SYNC_FINISHED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_CLOUD_REGION> SYNC = new Action(PUBLIC_CLOUD_REGION.class, "SYNC", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class WORKLOAD {
        public static final Action<WORKLOAD> SOFT_LIMIT_EXCEEDED = new Action(WORKLOAD.class, "SOFT_LIMIT_EXCEEDED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<WORKLOAD> HARD_LIMIT_EXCEEDED = new Action(WORKLOAD.class, "HARD_LIMIT_EXCEEDED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<WORKLOAD> SOFT_LIMIT_EXCEEDED_SYSTEM = new Action(WORKLOAD.class, "SOFT_LIMIT_EXCEEDED_SYSTEM", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<WORKLOAD> HARD_LIMIT_EXCEEDED_SYSTEM = new Action(WORKLOAD.class, "HARD_LIMIT_EXCEEDED_SYSTEM", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class BACKUP_POLICY {
        public static final Action<BACKUP_POLICY> CREATE = new Action(BACKUP_POLICY.class, "CREATE", new KEYS[]{KEYS.DC_NAME, KEYS.BACKUP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_POLICY> MODIFY = new Action(BACKUP_POLICY.class, "MODIFY", new KEYS[]{KEYS.DC_NAME, KEYS.BACKUP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_POLICY> DELETE = new Action(BACKUP_POLICY.class, "DELETE", new KEYS[]{KEYS.BACKUP_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_POLICY> ALLOW = new Action(BACKUP_POLICY.class, "ALLOW", new KEYS[]{KEYS.BACKUP_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<BACKUP_POLICY> RESTRICT = new Action(BACKUP_POLICY.class, "RESTRICT", new KEYS[]{KEYS.BACKUP_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class USER {
        public static final Action<USER> CREATE = new Action(USER.class, "CREATE", new KEYS[]{KEYS.ENT_NAME, KEYS.ENT_ID}, new KEYS[0], new KEYS[0]);
        public static final Action<USER> MODIFY = new Action(USER.class, "MODIFY", new KEYS[]{KEYS.USER_OLD_NAME, KEYS.ENT_NAME, KEYS.ENT_ID}, new KEYS[0], new KEYS[0]);
        public static final Action<USER> DELETE = new Action(USER.class, "DELETE", new KEYS[]{KEYS.USER_NAME, KEYS.ENT_NAME, KEYS.ENT_ID, KEYS.USER_SURNAME, KEYS.ROLE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<USER> RESET_PSW = new Action(USER.class, "RESET_PSW", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<USER> FIRST_LOGIN = new Action(USER.class, "FIRST_LOGIN", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<USER> TWO_FACTOR_CODE = new Action(USER.class, "TWO_FACTOR_CODE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<USER> ENABLE_TWO_FACTOR = new Action(USER.class, "ENABLE_TWO_FACTOR", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<USER> DISABLE_TWO_FACTOR = new Action(USER.class, "DISABLE_TWO_FACTOR", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class VOLUME {
        public static final Action<VOLUME> CREATE = new Action(VOLUME.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VOLUME_NAME, KEYS.VOLUME_SIZE, KEYS.TIER_NAME});
        public static final Action<VOLUME> MODIFY = new Action(VOLUME.class, "MODIFY", new KEYS[]{KEYS.VOLUME_OLD_NAME, KEYS.VOLUME_OLD_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VOLUME> RESIZE = new Action(VOLUME.class, "RESIZE", new KEYS[]{KEYS.VOLUME_OLD_NAME, KEYS.VOLUME_OLD_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VOLUME> MOVE = new Action(VOLUME.class, "MOVE", new KEYS[]{KEYS.VOLUME_NAME, KEYS.VOLUME_SIZE, KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VOLUME> DELETE = new Action(VOLUME.class, "DELETE", new KEYS[]{KEYS.VOLUME_NAME, KEYS.VOLUME_SIZE, KEYS.VMT_PERSISTENT_NAME}, new KEYS[]{KEYS.VOLUME_NAME}, new KEYS[]{KEYS.VOLUME_UUID});
    }

    public static final class DISK {
        public static final Action<DISK> CREATE = new Action(DISK.class, "CREATE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> COPY_FROM_TEMPLATE = new Action(DISK.class, "COPY_FROM_TEMPLATE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[]{KEYS.DISK_LABEL});
        public static final Action<DISK> COPY_FROM_TEMPLATE_START = new Action(DISK.class, "COPY_FROM_TEMPLATE_START", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_LABEL}, new KEYS[0], new KEYS[]{KEYS.DISK_LABEL});
        public static final Action<DISK> CONVERSION_CREATED_IN_REPO = new Action(DISK.class, "CONVERSION_CREATED_IN_REPO", new KEYS[]{KEYS.CONVERSION_TARGET_PATH, KEYS.CONVERSION_TARGET_TYPE}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> CREATED_IN_REPO = new Action(DISK.class, "CREATED_IN_REPO", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_PATH}, new KEYS[0], new KEYS[]{KEYS.DC_ID});
        public static final Action<DISK> UNAVAILABLE = new Action(DISK.class, "UNAVAILABLE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_LABEL}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> AVAILABLE = new Action(DISK.class, "AVAILABLE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> REPLACE = new Action(DISK.class, "REPLACE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> CONVERSION_AVAILABLE = new Action(DISK.class, "CONVERSION_AVAILABLE", new KEYS[]{KEYS.CONVERSION_TARGET_PATH}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> CREATE_FROM_DEF_FINISH = new Action(DISK.class, "CREATE_FROM_DEF_FINISH", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<DISK> CREATE_FROM_INST_FINISH = new Action(DISK.class, "CREATE_FROM_INST_FINISH", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<DISK> PERSISTENT_DELETE = new Action(DISK.class, "PERSISTENT_DELETE", new KEYS[]{KEYS.DISK_LABEL}, new KEYS[0], new KEYS[]{KEYS.DISK_LABEL, KEYS.DISK_PATH, KEYS.DISK_SIZE, KEYS.TEMPLATE_NAME});
        public static final Action<DISK> MODIFY = new Action(DISK.class, "MODIFY", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_LABEL}, new KEYS[0], new KEYS[0]);
        public static final Action<DISK> DELETE = new Action(DISK.class, "DELETE", new KEYS[]{KEYS.DISK_LABEL}, new KEYS[0], new KEYS[]{KEYS.TEMPLATE_NAME, KEYS.OVFID, KEYS.DISK_LABEL, KEYS.DISK_PATH, KEYS.DISK_SIZE});
    }

    public static final class VIRTUAL_MACHINE_TEMPLATE {
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> EXPORT_TASK_ENQUEUE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "EXPORT_TASK_ENQUEUE", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> IMPORTED_IN_REPO = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "IMPORTED_IN_REPO", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_PATH}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISK_PATH});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> CREATED_IN_REPO = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "CREATED_IN_REPO", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DC_ID}, new KEYS[0], new KEYS[]{KEYS.DC_ID});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> UNAVAILABLE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "UNAVAILABLE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> AVAILABLE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "AVAILABLE", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> CREATE_FROM_DEF_START = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "CREATE_FROM_DEF_START", new KEYS[]{KEYS.OVFID, KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DC_REPOSITORY}, new KEYS[0], new KEYS[]{KEYS.OVFID, KEYS.DC_NAME});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> CREATE_FROM_INST_START = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "CREATE_FROM_INST_START", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DISKS_LABEL}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.DC_NAME, KEYS.DISKS_LABEL});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> CREATE_FROM_DEF_FINISH = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "CREATE_FROM_DEF_FINISH", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> CREATE_FROM_INST_FINISH = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "CREATE_FROM_INST_FINISH", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_START = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_START", new KEYS[]{KEYS.VMT_PERSISTENT_NAME, KEYS.VMT_MASTER_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_FINISH = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_FINISH", new KEYS[]{KEYS.VMT_PERSISTENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_TASK_ENQUEUE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_TASK_ENQUEUE", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_RAW_CREATE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_RAW_CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_DUMP_START = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_DUMP_START", new KEYS[]{KEYS.VMT_PERSISTENT_NAME}, new KEYS[0], new KEYS[]{KEYS.VMT_PERSISTENT_NAME});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_DUMP_FINISH = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_DUMP_FINISH", new KEYS[]{KEYS.VMT_PERSISTENT_NAME, KEYS.DISK_LABEL, KEYS.DISK_SEQUENCE}, new KEYS[0], new KEYS[]{KEYS.VMT_PERSISTENT_NAME, KEYS.DISK_LABEL, KEYS.DISK_SEQUENCE});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_VOLUME_CREATE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_VOLUME_CREATE", new KEYS[]{KEYS.VMT_MASTER_NAME, KEYS.VMT_PERSISTENT_NAME, KEYS.VDC_NAME, KEYS.VOLUME_NAME, KEYS.DISK_LABEL, KEYS.DISK_SEQUENCE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_VOLUME_ASSIGN = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_VOLUME_ASSIGN", new KEYS[]{KEYS.VMT_MASTER_NAME, KEYS.VMT_PERSISTENT_NAME, KEYS.VDC_NAME, KEYS.VOLUME_NAME, KEYS.DISK_LABEL, KEYS.DISK_SEQUENCE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_MODIFY = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> PERSISTENT_DELETE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "PERSISTENT_DELETE", new KEYS[]{KEYS.VMT_PERSISTENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> MODIFY = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "MODIFY", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> DELETE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "DELETE", new KEYS[]{KEYS.TEMPLATE_NAME}, new KEYS[0], new KEYS[]{KEYS.TEMPLATE_NAME, KEYS.OVFID});
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> MOVE = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "MOVE", new KEYS[]{KEYS.VDC_ORIGIN, KEYS.VDC_DESTINATION}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> DISK_COPY_FROM_TEMPLATE_FINISH = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "DISK_COPY_FROM_TEMPLATE_FINISH", new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> SYNCH_AS_IMPORTED = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "SYNCH_AS_IMPORTED", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME, KEYS.PROVIDER_ID}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE_TEMPLATE> MODIFY_RECOMMENDED_HP = new Action(VIRTUAL_MACHINE_TEMPLATE.class, "MODIFY_RECOMMENDED_HP", new KEYS[0], new KEYS[]{KEYS.HP_NAME}, new KEYS[0]);
    }

    public static final class VIRTUAL_IMAGE_CONVERSION {
        public static final Action<VIRTUAL_IMAGE_CONVERSION> CREATED_IN_REPO = new Action(VIRTUAL_IMAGE_CONVERSION.class, "CREATED_IN_REPO", new KEYS[]{KEYS.CONVERSION_TARGET_PATH}, new KEYS[0], new KEYS[]{KEYS.DC_ID});
        public static final Action<VIRTUAL_IMAGE_CONVERSION> AVAILABLE = new Action(VIRTUAL_IMAGE_CONVERSION.class, "AVAILABLE", new KEYS[]{KEYS.CONVERSION_TARGET_PATH}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_IMAGE_CONVERSION> UNAVAILABLE = new Action(VIRTUAL_IMAGE_CONVERSION.class, "UNAVAILABLE", new KEYS[0], new KEYS[]{KEYS.CONVERSION_TARGET_PATH}, new KEYS[0]);
        public static final Action<VIRTUAL_IMAGE_CONVERSION> CONVERSION = new Action(VIRTUAL_IMAGE_CONVERSION.class, "CONVERSION", new KEYS[0], new KEYS[]{KEYS.TEMPLATE_NAME, KEYS.TEMPLATE_DISK_FORMAT_TYPE, KEYS.DC_NAME, KEYS.DC_OLD_NAME}, new KEYS[]{KEYS.TEMPLATE_NAME, KEYS.TEMPLATE_DISK_FORMAT_TYPE});
        public static final Action<VIRTUAL_IMAGE_CONVERSION> CONVERSION_FINISH = new Action(VIRTUAL_IMAGE_CONVERSION.class, "CONVERSION_FINISH", new KEYS[]{KEYS.CONVERSION_SOURCE_TYPE, KEYS.CONVERSION_TARGET_TYPE, KEYS.VMT_MASTER_NAME}, new KEYS[0], new KEYS[]{KEYS.CONVERSION_SOURCE_TYPE, KEYS.CONVERSION_TARGET_TYPE, KEYS.VMT_MASTER_NAME});
        public static final Action<VIRTUAL_IMAGE_CONVERSION> CONVERSION_INSTANCE_FINISH = new Action(VIRTUAL_IMAGE_CONVERSION.class, "CONVERSION_INSTANCE_FINISH", new KEYS[]{KEYS.TEMPLATE_NAME}, new KEYS[0], new KEYS[]{KEYS.TEMPLATE_NAME});
        public static final Action<VIRTUAL_IMAGE_CONVERSION> CONVERSION_TASK_ENQUEUE = new Action(VIRTUAL_IMAGE_CONVERSION.class, "CONVERSION_TASK_ENQUEUE", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[0]);
    }

    public static final class VIRTUAL_MACHINE {
        public static final Action<VIRTUAL_MACHINE> ALLOCATE_NICS = new Action(VIRTUAL_MACHINE.class, "ALLOCATE_NICS", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.IP, KEYS.VLAN_NETWORK_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.NICS_PER_VM, KEYS.CURRENT_NICS_SIZE, KEYS.REQUESTED_NICS_SIZE});
        public static final Action<VIRTUAL_MACHINE> DEALLOCATE_NICS = new Action(VIRTUAL_MACHINE.class, "DEALLOCATE_NICS", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.IP, KEYS.VLAN_NETWORK_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> ALLOCATE_HD = new Action(VIRTUAL_MACHINE.class, "ALLOCATE_HD", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.RASD_LIMIT}, new KEYS[]{KEYS.HARD_DISK_ID, KEYS.DISK_CONTROLLER, KEYS.DISK_CONTROLLER_DEFAULT}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEALLOCATE_HD = new Action(VIRTUAL_MACHINE.class, "DEALLOCATE_HD", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.DISK_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> ALLOCATE_VOLUME = new Action(VIRTUAL_MACHINE.class, "ALLOCATE_VOLUME", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.RASD_LIMIT, KEYS.VOLUME_NAME, KEYS.VOLUME_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEALLOCATE_VOLUME = new Action(VIRTUAL_MACHINE.class, "DEALLOCATE_VOLUME", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VOLUME_NAME, KEYS.VOLUME_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CAPTURE = new Action(VIRTUAL_MACHINE.class, "CAPTURE", new KEYS[]{KEYS.HYPERVISOR_IP, KEYS.HYPERVISOR_TYPE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> RELEASE = new Action(VIRTUAL_MACHINE.class, "RELEASE", new KEYS[]{KEYS.VDC_NAME, KEYS.VAPP_NAME, KEYS.VIRTUAL_MACHINE_NAME, KEYS.HYPERVISOR_IP, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CREATE = new Action(VIRTUAL_MACHINE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> IMPORT = new Action(VIRTUAL_MACHINE.class, "IMPORT", new KEYS[]{KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_IP}, new KEYS[]{KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_IP, KEYS.OTHER_HYPERVISOR_NAME, KEYS.OTHER_HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> INITIATOR_MAPPING = new Action(VIRTUAL_MACHINE.class, "INITIATOR_MAPPING", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> INSTANCE_START = new Action(VIRTUAL_MACHINE.class, "INSTANCE_START", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> INSTANCE_FINISH = new Action(VIRTUAL_MACHINE.class, "INSTANCE_FINISH", new KEYS[]{KEYS.TASK_OWNER}, new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> INSTANCE_DISK_COPY = new Action(VIRTUAL_MACHINE.class, "INSTANCE_DISK_COPY", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> INSTANCE_DUMP_VOLUME = new Action(VIRTUAL_MACHINE.class, "INSTANCE_DUMP_VOLUME", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> INSTANCE_CONVERSION_START = new Action(VIRTUAL_MACHINE.class, "INSTANCE_CONVERSION_START", new KEYS[]{KEYS.TEMPLATE_NAME}, new KEYS[]{KEYS.TEMPLATE_NAME}, new KEYS[]{KEYS.TEMPLATE_NAME});
        public static final Action<VIRTUAL_MACHINE> INSTANCE_CONVERSION_MASTER_START = new Action(VIRTUAL_MACHINE.class, "INSTANCE_CONVERSION_MASTER_START", new KEYS[]{KEYS.TEMPLATE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> INSTANCE_TEMPLATE_CREATE = new Action(VIRTUAL_MACHINE.class, "INSTANCE_TEMPLATE_CREATE", new KEYS[]{KEYS.TEMPLATE_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.TEMPLATE_NAME});
        public static final Action<VIRTUAL_MACHINE> LOCK_DELETE = new Action(VIRTUAL_MACHINE.class, "LOCK_DELETE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> LOCK_DEPLOY = new Action(VIRTUAL_MACHINE.class, "LOCK_DEPLOY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> LOCK_UNDEPLOY = new Action(VIRTUAL_MACHINE.class, "LOCK_UNDEPLOY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> LOCK_INSTANCE = new Action(VIRTUAL_MACHINE.class, "LOCK_INSTANCE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> LOCK_RECONFIGURE = new Action(VIRTUAL_MACHINE.class, "LOCK_RECONFIGURE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> MODIFY = new Action(VIRTUAL_MACHINE.class, "MODIFY", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VM_IPS, KEYS.NICS_PER_VM, KEYS.NEW_VM_IPS}, new KEYS[]{KEYS.VNIC_IP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_IP});
        public static final Action<VIRTUAL_MACHINE> DELETE = new Action(VIRTUAL_MACHINE.class, "DELETE", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> RESET = new Action(VIRTUAL_MACHINE.class, "RESET", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> RESUME = new Action(VIRTUAL_MACHINE.class, "RESUME", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> PAUSE = new Action(VIRTUAL_MACHINE.class, "PAUSE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> POWERON = new Action(VIRTUAL_MACHINE.class, "POWERON", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> POWEROFF = new Action(VIRTUAL_MACHINE.class, "POWEROFF", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE, KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> SHUTDOWN = new Action(VIRTUAL_MACHINE.class, "SHUTDOWN", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE, KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> STATE = new Action(VIRTUAL_MACHINE.class, "STATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> STATE_CHANGE = new Action(VIRTUAL_MACHINE.class, "STATE_CHANGE", new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE}, new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEPLOY = new Action(VIRTUAL_MACHINE.class, "DEPLOY", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_FQDN, KEYS.EVENT}, new KEYS[]{KEYS.CANDIDATES_SIZE, KEYS.REQUIREMENTS_CPU, KEYS.REQUIREMENTS_RAM, KEYS.CANDIDATES_NAMES, KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE, KEYS.RS_ERROR, KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> DEPLOY_FINISH = new Action(VIRTUAL_MACHINE.class, "DEPLOY_FINISH", new KEYS[]{KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.TASK_ID, KEYS.TASK_OWNER_ID, KEYS.TASK_TIMESTAMP, KEYS.NOTIFICATION, KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> DEPLOY_FREE_RESOURCES = new Action(VIRTUAL_MACHINE.class, "DEPLOY_FREE_RESOURCES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.TASK_ID});
        public static final Action<VIRTUAL_MACHINE> UNDEPLOY = new Action(VIRTUAL_MACHINE.class, "UNDEPLOY", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> UNDEPLOY_FINISH = new Action(VIRTUAL_MACHINE.class, "UNDEPLOY_FINISH", new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER_ID, KEYS.TASK_TIMESTAMP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP}, new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER_ID, KEYS.TASK_TIMESTAMP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP});
        public static final Action<VIRTUAL_MACHINE> RECONFIGURE = new Action(VIRTUAL_MACHINE.class, "RECONFIGURE", new KEYS[]{KEYS.CORES_PER_SOCKET, KEYS.RAM, KEYS.CPU, KEYS.DVD, KEYS.EXTRA_RECONFIGURE_MESSAGE}, new KEYS[]{KEYS.VLAN_NAME, KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP}, new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE, KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> MOVE_BY_HA = new Action(VIRTUAL_MACHINE.class, "MOVE_BY_HA", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP}, new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP});
        public static final Action<VIRTUAL_MACHINE> MOVE_BY_HA_FREE_RESOURCES = new Action(VIRTUAL_MACHINE.class, "MOVE_BY_HA_FREE_RESOURCES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> REFRESH = new Action(VIRTUAL_MACHINE.class, "REFRESH", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> REFRESH_RESOURCES = new Action(VIRTUAL_MACHINE.class, "REFRESH_RESOURCES", new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> UPDATE_RESOURCES = new Action(VIRTUAL_MACHINE.class, "UPDATE_RESOURCES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.MACHINE_NAME, KEYS.DATASTORE_NAME});
        public static final Action<VIRTUAL_MACHINE> START_INSTANCE = new Action(VIRTUAL_MACHINE.class, "START_INSTANCE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> STORE_RUNLIST = new Action(VIRTUAL_MACHINE.class, "STORE_RUNLIST", new KEYS[]{KEYS.RUN_LIST_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CHEF_RUNLIST_UPDATE = new Action(VIRTUAL_MACHINE.class, "CHEF_RUNLIST_UPDATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CHEF_RUNLIST_DELETE = new Action(VIRTUAL_MACHINE.class, "CHEF_RUNLIST_DELETE", new KEYS[]{KEYS.RUN_LIST_ELEMENT}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CHEF_CONNECT = new Action(VIRTUAL_MACHINE.class, "CHEF_CONNECT", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.CONNECTION_ENDPOINT, KEYS.CONNECTION_IDENTITY});
        public static final Action<VIRTUAL_MACHINE> DEPLOY_HA = new Action(VIRTUAL_MACHINE.class, "DEPLOY_HA", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.CONNECTION_ENDPOINT, KEYS.CONNECTION_IDENTITY, KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_OWNER_ID, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> UNDEPLOY_HA = new Action(VIRTUAL_MACHINE.class, "UNDEPLOY_HA", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.CONNECTION_ENDPOINT, KEYS.CONNECTION_IDENTITY, KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.TASK_OWNER_ID, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE});
        public static final Action<VIRTUAL_MACHINE> ASYNC_HANDLER_RESPONSE = new Action(VIRTUAL_MACHINE.class, "ASYNC_HANDLER_RESPONSE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_TYPE, KEYS.HANDLER_NAME, KEYS.EXCEPTION_CLASS, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_MACHINE> VSM_CHANGE_STATE = new Action(VIRTUAL_MACHINE.class, "VSM_CHANGE_STATE", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VIRTUAL_MACHINE_STATE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> VSM_VM_DESTROYED = new Action(VIRTUAL_MACHINE.class, "VSM_VM_DESTROYED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> VSM_VM_MOVED = new Action(VIRTUAL_MACHINE.class, "VSM_VM_MOVED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.CLONED_VM_MACHINE_NAME, KEYS.MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME, KEYS.ROOT_PATH, KEYS.DC_NAME, KEYS.LAYER, KEYS.ENT_NAME});
        public static final Action<VIRTUAL_MACHINE> VSM_VM_UNSUBSCRIBE = new Action(VIRTUAL_MACHINE.class, "VSM_VM_UNSUBSCRIBE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> VSM_VM_RETRIEVE = new Action(VIRTUAL_MACHINE.class, "VSM_VM_RETRIEVE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> WORKFLOW_UNDEPLOY_SEND = new Action(VIRTUAL_MACHINE.class, "WORKFLOW_UNDEPLOY_SEND", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[]{KEYS.TASK_ID});
        public static final Action<VIRTUAL_MACHINE> WORKFLOW_RECONFIGURE_SEND = new Action(VIRTUAL_MACHINE.class, "WORKFLOW_RECONFIGURE_SEND", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[]{KEYS.TASK_ID});
        public static final Action<VIRTUAL_MACHINE> WORKFLOW_DEPLOY_SEND = new Action(VIRTUAL_MACHINE.class, "WORKFLOW_DEPLOY_SEND", new KEYS[]{KEYS.TASK_ID}, new KEYS[0], new KEYS[]{KEYS.TASK_ID});
        public static final Action<VIRTUAL_MACHINE> METADATA_MODIFIED = new Action(VIRTUAL_MACHINE.class, "METADATA_MODIFIED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> FIREWALL_POLICY = new Action(VIRTUAL_MACHINE.class, "FIREWALL_POLICY", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_RAM_CHANGED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_RAM_CHANGED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_CPU_CHANGED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_CPU_CHANGED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_CORES_PER_SOCKET_CHANGED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_CORES_PER_SOCKET_CHANGED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_DATASTORE_CHANGED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_DATASTORE_CHANGED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_PROFILE_CHANGED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_PROFILE_CHANGED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_FLOATINGIP_ADDED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_FLOATINGIP_ADDED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_TAG_CONFLICT = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_TAG_CONFLICT", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VNIC_MAC, KEYS.VNIC_TAG_DB, KEYS.VNIC_TAG_PROVIDER}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_DISK_ADDED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_DISK_ADDED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.DISK_URL}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_DISK_REMOVED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_DISK_REMOVED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.DISK_URL}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_DISK_RESIZE = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_DISK_RESIZE", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.DISK_URL, KEYS.HARD_DISK_SIZE, KEYS.HARD_DISK_OLD_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_VOLUME_ADDED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_VOLUME_ADDED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VOLUME_URL}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_VOLUME_REMOVED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_VOLUME_REMOVED", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VOLUME_URL}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> DEFINITION_SYNCER_VOLUME_REPLACED = new Action(VIRTUAL_MACHINE.class, "DEFINITION_SYNCER_VOLUME_REPLACED", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VOLUME_URL, KEYS.DISK_URL}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> RESTORE_BACKUP = new Action(VIRTUAL_MACHINE.class, "RESTORE_BACKUP", new KEYS[]{KEYS.BACKUP_ID, KEYS.BACKUP_NAME, KEYS.BACKUP_DATE, KEYS.BACKUP_SIZE, KEYS.BACKUP_TYPE}, new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.VIRTUAL_MACHINE_NAME, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_MACHINE> PROTECT = new Action(VIRTUAL_MACHINE.class, "PROTECT", new KEYS[]{KEYS.USER_NAME, KEYS.CAUSE}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> UNPROTECT = new Action(VIRTUAL_MACHINE.class, "UNPROTECT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<?> SYNC_CREATE = new Action(VIRTUAL_MACHINE.class, "SYNC_CREATE", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<?> SYNC_CREATE_HP_NOT_RECOMMENDED = new Action(VIRTUAL_MACHINE.class, "SYNC_CREATE_HP_NOT_RECOMMENDED", new KEYS[0], new KEYS[]{KEYS.LOCATION_NAME, KEYS.VIRTUAL_MACHINE_TEMPLATE_NAME}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> REGISTER = new Action(VIRTUAL_MACHINE.class, "REGISTER", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> UNREGISTER = new Action(VIRTUAL_MACHINE.class, "UNREGISTER", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> UPDATE_REGISTER = new Action(VIRTUAL_MACHINE.class, "UPDATE_REGISTER", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_MACHINE> VALIDATE = new Action(VIRTUAL_MACHINE.class, "VALIDATE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> REQUEST_BACKUP = new Action(VIRTUAL_MACHINE.class, "REQUEST_BACKUP", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.VIRTUAL_MACHINE_NAME, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_MACHINE> REQUEST_BACKUP_WITH_REPLICATION = new Action(VIRTUAL_MACHINE.class, "REQUEST_BACKUP_WITH_REPLICATION", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> BACKUP_FINISH = new Action(VIRTUAL_MACHINE.class, "BACKUP_FINISH", new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME, KEYS.CAUSE});
        public static final Action<VIRTUAL_MACHINE> BACKUP_WITH_REPLICATION_FINISH = new Action(VIRTUAL_MACHINE.class, "BACKUP_WITH_REPLICATION_FINISH", new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME, KEYS.CAUSE});
        public static final Action<VIRTUAL_MACHINE> RESTORE_FINISH = new Action(VIRTUAL_MACHINE.class, "RESTORE_FINISH", new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.BACKUP_ID, KEYS.VIRTUAL_MACHINE_NAME, KEYS.CAUSE});
        public static final Action<VIRTUAL_MACHINE> CLONE = new Action(VIRTUAL_MACHINE.class, "CLONE", new KEYS[]{KEYS.VAPP_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VAPP_NAME});
        public static final Action<VIRTUAL_MACHINE> ADD_BACKUP_POLICY = new Action(VIRTUAL_MACHINE.class, "ADD_BACKUP_POLICY", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.BACKUP_POLICY_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> REMOVE_BACKUP_POLICY = new Action(VIRTUAL_MACHINE.class, "REMOVE_BACKUP_POLICY", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.BACKUP_POLICY_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> BACKUP_SCHEDULE = new Action(VIRTUAL_MACHINE.class, "BACKUP_SCHEDULE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID, KEYS.TASK_OWNER, KEYS.VIRTUAL_MACHINE_NAME, KEYS.TASK_TIMESTAMP, KEYS.HYPERVISOR_NAME, KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.TASK_ERROR});
        public static final Action<VIRTUAL_MACHINE> RELOCATE = new Action(VIRTUAL_MACHINE.class, "RELOCATE", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.EVENT});
        public static final Action<VIRTUAL_MACHINE> REQUEST_ACCESS = new Action(VIRTUAL_MACHINE.class, "REQUEST_ACCESS", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.USER_NICK, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> GUEST_SETUP = new Action(VIRTUAL_MACHINE.class, "GUEST_SETUP", new KEYS[]{KEYS.GUEST_SETUP, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[]{KEYS.GUEST_SETUP, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> CAPTURE_DHCP = new Action(VIRTUAL_MACHINE.class, "CAPTURE_DHCP", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> GUEST_PASSWORD_EMAIL = new Action(VIRTUAL_MACHINE.class, "GUEST_PASSWORD_EMAIL", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> GUEST_PASSWORD_SMS = new Action(VIRTUAL_MACHINE.class, "GUEST_PASSWORD_SMS", new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0]);
        public static final Action<VIRTUAL_MACHINE> MOVE_TO_VAPP = new Action(VIRTUAL_MACHINE.class, "MOVE_TO_VAPP", new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME, KEYS.VAPP_NAME, KEYS.VAPP_MOVED_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class PRIVATE_IP {
        public static final Action<PRIVATE_IP> CREATE = new Action(PRIVATE_IP.class, "CREATE", new KEYS[]{KEYS.VDC_NAME, KEYS.PRIVATE_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_IP> CREATE_BULK = new Action(PRIVATE_IP.class, "CREATE_BULK", new KEYS[]{KEYS.VDC_NAME, KEYS.PRIVATE_NET_NAME, KEYS.PRIVATE_NET_ID, KEYS.IP_ADDRESSES}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_IP> SYNC_CREATE = new Action(PRIVATE_IP.class, "SYNC_CREATE", new KEYS[]{KEYS.IP, KEYS.VLAN_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_IP> SYNC_DETACH = new Action(PRIVATE_IP.class, "SYNC_DETACH", new KEYS[]{KEYS.IP, KEYS.VLAN_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_IP> SYNC_RESERVED = new Action(PRIVATE_IP.class, "SYNC_RESERVED", new KEYS[]{KEYS.IP, KEYS.VLAN_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_IP> DELETE = new Action(PRIVATE_IP.class, "DELETE", new KEYS[]{KEYS.VDC_NAME, KEYS.PRIVATE_NET_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class PUBLIC_IP {
        public static final Action<PUBLIC_IP> CREATE = new Action(PUBLIC_IP.class, "CREATE", new KEYS[]{KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> CREATE_BULK = new Action(PUBLIC_IP.class, "CREATE_BULK", new KEYS[]{KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME, KEYS.PUBLIC_NET_ID, KEYS.IP_ADDRESSES}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> DELETE = new Action(PUBLIC_IP.class, "DELETE", new KEYS[]{KEYS.IP, KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> PURCHASE = new Action(PUBLIC_IP.class, "PURCHASE", new KEYS[]{KEYS.VDC_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> RELEASE = new Action(PUBLIC_IP.class, "RELEASE", new KEYS[]{KEYS.VDC_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> CREATE_FLOATINGIP = new Action(PUBLIC_IP.class, "CREATE_FLOATINGIP", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> RELEASE_FLOATINGIP = new Action(PUBLIC_IP.class, "RELEASE_FLOATINGIP", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> CREATE_IMPORT_FLOATINGIP = new Action(PUBLIC_IP.class, "CREATE_IMPORT_FLOATINGIP", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> CREATE_IMPORT_UNAVAILABLE_FLOATINGIP = new Action(PUBLIC_IP.class, "CREATE_IMPORT_UNAVAILABLE_FLOATINGIP", new KEYS[]{KEYS.DC_NAME, KEYS.DC_OLD_NAME, KEYS.ENT_NAME, KEYS.ENT_OLD_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> RELEASE_IMPORT_FLOATINGIP = new Action(PUBLIC_IP.class, "RELEASE_IMPORT_FLOATINGIP", new KEYS[]{KEYS.DC_NAME, KEYS.ENT_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_IP> MODIFY_IMPORT_FLOATINGIP = new Action(PUBLIC_IP.class, "MODIFY_IMPORT_FLOATINGIP", new KEYS[]{KEYS.IP, KEYS.DC_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class EXTERNAL_IP {
        public static final Action<EXTERNAL_IP> CREATE = new Action(EXTERNAL_IP.class, "CREATE", new KEYS[]{KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_IP> CREATE_BULK = new Action(EXTERNAL_IP.class, "CREATE_BULK", new KEYS[]{KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME, KEYS.PUBLIC_NET_ID, KEYS.IP_ADDRESSES}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_IP> DELETE = new Action(EXTERNAL_IP.class, "DELETE", new KEYS[]{KEYS.IP, KEYS.DC_NAME, KEYS.PUBLIC_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_IP> SYNC_CREATE = new Action(EXTERNAL_IP.class, "SYNC_CREATE", new KEYS[]{KEYS.IP, KEYS.VLAN_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_IP> SYNC_DETACH = new Action(EXTERNAL_IP.class, "SYNC_DETACH", new KEYS[]{KEYS.IP, KEYS.VLAN_NAME, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class VIRTUAL_DATACENTER {
        public static final Action<VIRTUAL_DATACENTER> CREATE = new Action(VIRTUAL_DATACENTER.class, "CREATE", new KEYS[]{KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> DELETE = new Action(VIRTUAL_DATACENTER.class, "DELETE", new KEYS[]{KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> MODIFY = new Action(VIRTUAL_DATACENTER.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> NETWORK_DEFAULT = new Action(VIRTUAL_DATACENTER.class, "NETWORK_DEFAULT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> FIREWALL_DEFAULT = new Action(VIRTUAL_DATACENTER.class, "FIREWALL_DEFAULT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> REMOVE_FIREWALL_DEFAULT = new Action(VIRTUAL_DATACENTER.class, "REMOVE_FIREWALL_DEFAULT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_DATACENTER> SYNC = new Action(VIRTUAL_DATACENTER.class, "SYNC", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<?> SYNC_START = new Action(VIRTUAL_DATACENTER.class, "SYNC_START", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<?> SYNC_FINISHED = new Action(VIRTUAL_DATACENTER.class, "SYNC_FINISHED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<?> UPDATE_TYPE = new Action(VIRTUAL_DATACENTER.class, "UPDATE_TYPE", new KEYS[0], new KEYS[]{KEYS.HYPERVISOR_TYPE}, new KEYS[0]);
    }

    public static final class VIRTUAL_APPLIANCE {
        public static final Action<VIRTUAL_APPLIANCE> CREATE = new Action(VIRTUAL_APPLIANCE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE> MODIFY = new Action(VIRTUAL_APPLIANCE.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE> DELETE = new Action(VIRTUAL_APPLIANCE.class, "DELETE", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE> LOCK_DELETE = new Action(VIRTUAL_APPLIANCE.class, "LOCK_DELETE", new KEYS[]{KEYS.VAPP_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE> DEPLOY = new Action(VIRTUAL_APPLIANCE.class, "DEPLOY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<VIRTUAL_APPLIANCE> UNDEPLOY = new Action(VIRTUAL_APPLIANCE.class, "UNDEPLOY", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.VIRTUAL_MACHINE_NAME});
        public static final Action<VIRTUAL_APPLIANCE> MOVE = new Action(VIRTUAL_APPLIANCE.class, "MOVE", new KEYS[]{KEYS.VAPP_ORIGINAL_NAME, KEYS.VAPP_NAME, KEYS.VDC_ORIGIN, KEYS.VDC_DESTINATION}, new KEYS[0], new KEYS[]{KEYS.DISK_TYPE, KEYS.HYPERVISOR_TYPE});
        public static final Action<VIRTUAL_APPLIANCE> COPY = new Action(VIRTUAL_APPLIANCE.class, "COPY", new KEYS[]{KEYS.VAPP_ORIGINAL_NAME, KEYS.VAPP_NAME, KEYS.VDC_ORIGIN, KEYS.VDC_DESTINATION}, new KEYS[0], new KEYS[]{KEYS.DISK_TYPE, KEYS.HYPERVISOR_TYPE});
        public static final Action<VIRTUAL_APPLIANCE> WORKFLOW_UNDEPLOY_BATCH = new Action(VIRTUAL_APPLIANCE.class, "WORKFLOW_UNDEPLOY_BATCH", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID});
        public static final Action<VIRTUAL_APPLIANCE> WORKFLOW_DEPLOY_BATCH = new Action(VIRTUAL_APPLIANCE.class, "WORKFLOW_DEPLOY_BATCH", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.TASK_ID});
    }

    public static final class DATASTORE_TIER {
        public static final Action<DATASTORE_TIER> CREATE = new Action(DATASTORE_TIER.class, "CREATE", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATASTORE_TIER> MODIFY = new Action(DATASTORE_TIER.class, "MODIFY", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.DC_NAME}, new KEYS[]{KEYS.ENT_OLD_NAME}, new KEYS[0]);
        public static final Action<DATASTORE_TIER> DELETE = new Action(DATASTORE_TIER.class, "DELETE", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATASTORE_TIER> ALLOW = new Action(DATASTORE_TIER.class, "ALLOW", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATASTORE_TIER> RESTRICT = new Action(DATASTORE_TIER.class, "RESTRICT", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATASTORE_TIER> ADD_DATASTORE = new Action(DATASTORE_TIER.class, "ADD_DATASTORE", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.DC_NAME, KEYS.DATASTORE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATASTORE_TIER> RELEASE_DATASTORE = new Action(DATASTORE_TIER.class, "RELEASE_DATASTORE", new KEYS[]{KEYS.DATASTORE_TIER_NAME, KEYS.DC_NAME, KEYS.DATASTORE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class TIER {
        public static final Action<TIER> CREATE = new Action(TIER.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TIER> MODIFY = new Action(TIER.class, "MODIFY", new KEYS[0], new KEYS[]{KEYS.ENT_OLD_NAME}, new KEYS[0]);
        public static final Action<TIER> DELETE = new Action(TIER.class, "DELETE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TIER> ALLOW = new Action(TIER.class, "ALLOW", new KEYS[]{KEYS.TIER_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<TIER> RESTRICT = new Action(TIER.class, "RESTRICT", new KEYS[]{KEYS.TIER_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class TEMPLATE_DEFINITION_LIST {
        public static final Action<TEMPLATE_DEFINITION_LIST> CREATE = new Action(TEMPLATE_DEFINITION_LIST.class, "CREATE", new KEYS[0], new KEYS[]{KEYS.TEMPLATE_DEF_LIST_VALIDATION, KEYS.TEMPLATE_NAME}, new KEYS[0]);
        public static final Action<TEMPLATE_DEFINITION_LIST> MODIFY = new Action(TEMPLATE_DEFINITION_LIST.class, "MODIFY", new KEYS[]{KEYS.TEMPLATE_DEFINITION_LIST_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<TEMPLATE_DEFINITION_LIST> DELETE = new Action(TEMPLATE_DEFINITION_LIST.class, "DELETE", new KEYS[]{KEYS.TEMPLATE_DEFINITION_LIST_OLD_NAME, KEYS.TEMPLATE_DEF_LIST_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class TASK {
        public static final Action<TASK> FIND = new Action(TASK.class, "FIND", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> UNDEPLOY_CANCEL = new Action(TASK.class, "UNDEPLOY_CANCEL", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> RECONFIGURE_CANCEL = new Action(TASK.class, "RECONFIGURE_CANCEL", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> DEPLOY_CANCEL = new Action(TASK.class, "DEPLOY_CANCEL", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> UNDEPLOY_CONTINUE = new Action(TASK.class, "UNDEPLOY_CONTINUE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> RECONFIGURE_CONTINUE = new Action(TASK.class, "RECONFIGURE_CONTINUE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<TASK> DEPLOY_CONTINUE = new Action(TASK.class, "DEPLOY_CONTINUE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class STORAGE_POOL {
        public static final Action<STORAGE_POOL> CREATE = new Action(STORAGE_POOL.class, "CREATE", new KEYS[]{KEYS.STORAGE_POOL_NAME, KEYS.STORAGE_DEVICE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<STORAGE_POOL> MODIFY = new Action(STORAGE_POOL.class, "MODIFY", new KEYS[]{KEYS.TIER_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<STORAGE_POOL> DELETE = new Action(STORAGE_POOL.class, "DELETE", new KEYS[]{KEYS.STORAGE_POOL_NAME, KEYS.STORAGE_DEVICE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class STORAGE_DEVICE {
        public static final Action<STORAGE_DEVICE> CREATE = new Action(STORAGE_DEVICE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<STORAGE_DEVICE> MODIFY = new Action(STORAGE_DEVICE.class, "MODIFY", new KEYS[]{KEYS.STORAGE_DEVICE_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<STORAGE_DEVICE> DELETE = new Action(STORAGE_DEVICE.class, "DELETE", new KEYS[]{KEYS.STORAGE_DEVICE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<STORAGE_DEVICE> INITIATOR_ADD = new Action(STORAGE_DEVICE.class, "INITIATOR_ADD", new KEYS[]{KEYS.INITIATORIQN, KEYS.VOLUME_NAME}, new KEYS[0], new KEYS[]{KEYS.INITIATORIQN, KEYS.VOLUME_NAME});
    }

    public static final class SCOPE {
        public static final Action<SCOPE> CREATE = new Action(SCOPE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SCOPE> MODIFY = new Action(SCOPE.class, "MODIFY", new KEYS[]{KEYS.SCOPE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<SCOPE> DELETE = new Action(SCOPE.class, "DELETE", new KEYS[]{KEYS.SCOPE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class SESSION {
        public static final Action<SESSION> LOGIN = new Action(SESSION.class, "LOGIN", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SESSION> LOGOUT = new Action(SESSION.class, "LOGOUT", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class SCHEDULER {
        public static final Action<SCHEDULER> BEST_TARGET = new Action(SCHEDULER.class, "BEST_TARGET", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SCHEDULER> DATASTORE = new Action(SCHEDULER.class, "DATASTORE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SCHEDULER> FREE_PORT = new Action(SCHEDULER.class, "FREE_PORT", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SCHEDULER> FREE_VLAN = new Action(SCHEDULER.class, "FREE_VLAN", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<SCHEDULER> FIRST_CANDIDATES = new Action(SCHEDULER.class, "FIRST_CANDIDATES", new KEYS[0], new KEYS[]{KEYS.RACK_NAME, KEYS.CAUSE}, new KEYS[0]);
        public static final Action<SCHEDULER> VIRTUAL_MACHINE = new Action(SCHEDULER.class, "VIRTUAL_MACHINE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class RULES {
        public static final Action<RULES> APPLY = new Action(RULES.class, "APPLY", new KEYS[]{KEYS.ENTERPRISE1, KEYS.ENTERPRISE2}, new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADLEVEL_APPLY = new Action(RULES.class, "LOADLEVEL_APPLY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADLEVEL_DELETE = new Action(RULES.class, "LOADLEVEL_DELETE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADLEVEL_CPU_EXCEEDED = new Action(RULES.class, "LOADLEVEL_CPU_EXCEEDED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADLEVEL_RAM_EXCEEDED = new Action(RULES.class, "LOADLEVEL_RAM_EXCEEDED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADLEVEL_DATASTORE_EXCEEDED = new Action(RULES.class, "LOADLEVEL_DATASTORE_EXCEEDED", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADBALANCE_APPLY = new Action(RULES.class, "LOADBALANCE_APPLY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RULES> LOADBALANCE_DELETE = new Action(RULES.class, "LOADBALANCE_DELETE", new KEYS[]{KEYS.LOADBALANCE_TYPE}, new KEYS[0], new KEYS[0]);
        public static final Action<RULES> RESTRICTSHARED_APPLY = new Action(RULES.class, "RESTRICTSHARED_APPLY", new KEYS[]{KEYS.ENTERPRISE1, KEYS.ENTERPRISE2}, new KEYS[0], new KEYS[0]);
        public static final Action<RULES> RESTRICTSHARED_DELETE = new Action(RULES.class, "RESTRICTSHARED_DELETE", new KEYS[]{KEYS.ENTERPRISE1, KEYS.ENTERPRISE2}, new KEYS[0], new KEYS[0]);
    }

    public static final class ROLE {
        public static final Action<ROLE> CREATE = new Action(ROLE.class, "CREATE", new KEYS[]{KEYS.ENT_NAME, KEYS.ROLE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ROLE> MODIFY = new Action(ROLE.class, "MODIFY", new KEYS[]{KEYS.ROLE_OLD_NAME, KEYS.ROLE_OLD_ENT, KEYS.ENT_NAME, KEYS.PRIVILEGES_ADDED, KEYS.PRIVILEGES_DELETED, KEYS.ROLE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ROLE> DELETE = new Action(ROLE.class, "DELETE", new KEYS[]{KEYS.ROLE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class REMOTE_SERVICE {
        public static final Action<REMOTE_SERVICE> CREATE = new Action(REMOTE_SERVICE.class, "CREATE", new KEYS[0], new KEYS[]{KEYS.RS_URI, KEYS.DC_NAME, KEYS.RS_ERROR}, new KEYS[0]);
        public static final Action<REMOTE_SERVICE> MODIFY = new Action(REMOTE_SERVICE.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<REMOTE_SERVICE> DELETE = new Action(REMOTE_SERVICE.class, "DELETE", new KEYS[]{KEYS.RS_TYPE, KEYS.RS_URI}, new KEYS[0], new KEYS[0]);
        public static final Action<REMOTE_SERVICE> CHECK = new Action(REMOTE_SERVICE.class, "CHECK", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.RS_TYPE});
    }

    public static final class RACK {
        public static final Action<RACK> CREATE = new Action(RACK.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<RACK> MODIFY = new Action(RACK.class, "MODIFY", new KEYS[]{KEYS.RACK_OLD_NAME}, new KEYS[0], new KEYS[]{KEYS.RACK_NAME});
        public static final Action<RACK> DELETE = new Action(RACK.class, "DELETE", new KEYS[]{KEYS.RACK_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class VLAN_TAG {
        public static final Action<VLAN_TAG> ASSIGN = new Action(VLAN_TAG.class, "ASSIGN", new KEYS[]{KEYS.RACK_NAME, KEYS.DC_NAME, KEYS.VDC_NAME, KEYS.VLAN_TAG}, new KEYS[0], new KEYS[0]);
        public static final Action<VLAN_TAG> UNASSIGN = new Action(VLAN_TAG.class, "UNASSIGN", new KEYS[]{KEYS.RACK_NAME, KEYS.DC_NAME, KEYS.VDC_NAME, KEYS.VLAN_TAG}, new KEYS[0], new KEYS[0]);
    }

    public static final class CLASSIC_FIREWALL_RULE {
        public static final Action<CLASSIC_FIREWALL_RULE> CREATE = new Action(CLASSIC_FIREWALL_RULE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> MODIFY = new Action(CLASSIC_FIREWALL_RULE.class, "MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> REORDER = new Action(CLASSIC_FIREWALL_RULE.class, "REORDER", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> DELETE = new Action(CLASSIC_FIREWALL_RULE.class, "DELETE", new KEYS[]{KEYS.PROVIDER_ID}, new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> SYNC_CREATE = new Action(CLASSIC_FIREWALL_RULE.class, "SYNC_CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> SYNC_MODIFY = new Action(CLASSIC_FIREWALL_RULE.class, "SYNC_MODIFY", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL_RULE> SYNC_DELETE = new Action(CLASSIC_FIREWALL_RULE.class, "SYNC_DELETE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class CLASSIC_FIREWALL {
        public static final Action<CLASSIC_FIREWALL> SYNC_ALL = new Action(CLASSIC_FIREWALL.class, "SYNC_ALL", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL> SYNC = new Action(CLASSIC_FIREWALL.class, "SYNC", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL> MODIFY = new Action(CLASSIC_FIREWALL.class, "MODIFY", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL> SYNC_CREATE = new Action(CLASSIC_FIREWALL.class, "SYNC_CREATE", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CLASSIC_FIREWALL> SYNC_DELETE = new Action(CLASSIC_FIREWALL.class, "SYNC_DELETE", new KEYS[]{KEYS.LOCATION_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class NAT_RULE {
        public static final Action<NAT_RULE> CREATE = new Action(NAT_RULE.class, "CREATE", new KEYS[]{KEYS.NAT_IP, KEYS.IP, KEYS.NAT_PORT_ORIGINAL, KEYS.NAT_PORT_TRANSLATED, KEYS.NAT_SNAT, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_RULE> DELETE = new Action(NAT_RULE.class, "DELETE", new KEYS[]{KEYS.NAT_IP, KEYS.IP, KEYS.NAT_PORT_ORIGINAL, KEYS.NAT_PORT_TRANSLATED, KEYS.NAT_SNAT, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class NAT_IP {
        public static final Action<NAT_IP> CREATE = new Action(NAT_IP.class, "CREATE", new KEYS[]{KEYS.DC_NAME, KEYS.NAT_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> CREATE_BULK = new Action(NAT_IP.class, "CREATE_BULK", new KEYS[]{KEYS.DC_NAME, KEYS.NAT_NET_NAME, KEYS.IP_ADDRESSES}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> DELETE = new Action(NAT_IP.class, "DELETE", new KEYS[]{KEYS.IP, KEYS.DC_NAME, KEYS.NAT_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> PURCHASE = new Action(NAT_IP.class, "PURCHASE", new KEYS[]{KEYS.VDC_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> RELEASE = new Action(NAT_IP.class, "RELEASE", new KEYS[]{KEYS.VDC_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> QUARANTINE = new Action(NAT_IP.class, "QUARANTINE", new KEYS[]{KEYS.IP, KEYS.QUARANTINE}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_IP> SNAT_NET = new Action(NAT_IP.class, "SNAT_NET", new KEYS[]{KEYS.VDC_NAME, KEYS.IP}, new KEYS[0], new KEYS[0]);
    }

    public static final class NAT_NETWORK {
        public static final Action<NAT_NETWORK> CREATE = new Action(NAT_NETWORK.class, "CREATE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NAT_NETWORK> DELETE = new Action(NAT_NETWORK.class, "DELETE", new KEYS[]{KEYS.NAT_NET_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class PUBLIC_NETWORK {
        public static final Action<PUBLIC_NETWORK> CREATE = new Action(PUBLIC_NETWORK.class, "CREATE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_NETWORK> GATEWAY_OUT_OF_RANGE = new Action(PUBLIC_NETWORK.class, "GATEWAY_OUT_OF_RANGE", new KEYS[0], new KEYS[]{KEYS.GATEWAY_OLD}, new KEYS[0]);
        public static final Action<PUBLIC_NETWORK> MODIFY = new Action(PUBLIC_NETWORK.class, "MODIFY", new KEYS[]{KEYS.PUBLIC_NET_OLD_NAME, KEYS.PUBLIC_NET_TYPE, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PUBLIC_NETWORK> DELETE = new Action(PUBLIC_NETWORK.class, "DELETE", new KEYS[]{KEYS.PUBLIC_NET_NAME, KEYS.PUBLIC_NET_TYPE, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class PRIVATE_NETWORK {
        public static final Action<PRIVATE_NETWORK> CREATE = new Action(PRIVATE_NETWORK.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> MODIFY = new Action(PRIVATE_NETWORK.class, "MODIFY", new KEYS[]{KEYS.PRIVATE_NET_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> GATEWAY_OVERWRITE = new Action(PRIVATE_NETWORK.class, "GATEWAY_OVERWRITE", new KEYS[0], new KEYS[]{KEYS.GATEWAY_OLD, KEYS.GATEWAY_NEW}, new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> GATEWAY_OUT_OF_RANGE = new Action(PRIVATE_NETWORK.class, "GATEWAY_OUT_OF_RANGE", new KEYS[0], new KEYS[]{KEYS.GATEWAY_OLD}, new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> DELETE = new Action(PRIVATE_NETWORK.class, "DELETE", new KEYS[]{KEYS.PRIVATE_NET_NAME, KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> DEFAULT = new Action(PRIVATE_NETWORK.class, "DEFAULT", new KEYS[]{KEYS.PRIVATE_NET_NAME, KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> SYNC_CREATE = new Action(PRIVATE_NETWORK.class, "SYNC_CREATE", new KEYS[]{KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> SYNC_DETACH = new Action(PRIVATE_NETWORK.class, "SYNC_DETACH", new KEYS[]{KEYS.VDC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRIVATE_NETWORK> SYNC_UPDATE = new Action(PRIVATE_NETWORK.class, "SYNC_UPDATE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class PRICING_TEMPLATE {
        public static final Action<PRICING_TEMPLATE> CREATE = new Action(PRICING_TEMPLATE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<PRICING_TEMPLATE> MODIFY = new Action(PRICING_TEMPLATE.class, "MODIFY", new KEYS[]{KEYS.PRICING_TEMPLATE_NAME, KEYS.PRICING_TEMPLATE_PRICES}, new KEYS[0], new KEYS[0]);
        public static final Action<PRICING_TEMPLATE> DELETE = new Action(PRICING_TEMPLATE.class, "DELETE", new KEYS[]{KEYS.PRICING_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<PRICING_TEMPLATE> MODIFY_DC = new Action(PRICING_TEMPLATE.class, "MODIFY_DC", new KEYS[]{KEYS.PRICING_TEMPLATE_NAME, KEYS.PRICING_TEMPLATE_PRICES, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class NETWORK_SERVICE_TYPE {
        public static final Action<NETWORK_SERVICE_TYPE> CREATE = new Action(NETWORK_SERVICE_TYPE.class, "CREATE", new KEYS[]{KEYS.NST_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NETWORK_SERVICE_TYPE> MODIFY = new Action(NETWORK_SERVICE_TYPE.class, "MODIFY", new KEYS[]{KEYS.NST_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<NETWORK_SERVICE_TYPE> DELETE = new Action(NETWORK_SERVICE_TYPE.class, "DELETE", new KEYS[]{KEYS.NST_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class MACHINE {
        public static final Action<MACHINE> CREATE = new Action(MACHINE.class, "CREATE", new KEYS[]{KEYS.HYPERVISOR_TYPE, KEYS.HYPERVISOR_IP, KEYS.RAM, KEYS.HARD_DISK_SIZE}, new KEYS[]{KEYS.DATASTORE_NAME}, new KEYS[0]);
        public static final Action<MACHINE> MODIFY = new Action(MACHINE.class, "MODIFY", new KEYS[]{KEYS.MACHINE_OLD_NAME, KEYS.MACHINE_OLD_IP, KEYS.MACHINE_OLD_HYP, KEYS.MACHINE_OLD_STATE}, new KEYS[]{KEYS.MACHINE_OLD_NAME, KEYS.MACHINE_OLD_IP, KEYS.MACHINE_OLD_HYP, KEYS.MACHINE_OLD_STATE}, new KEYS[0]);
        public static final Action<MACHINE> DELETE = new Action(MACHINE.class, "DELETE", new KEYS[]{KEYS.MACHINE_OLD_NAME, KEYS.MACHINE_OLD_IP, KEYS.MACHINE_OLD_HYP, KEYS.MACHINE_OLD_STATE, KEYS.MACHINE_NAME, KEYS.MACHINE_IP, KEYS.MACHINE_HYP, KEYS.MACHINE_STATE}, new KEYS[]{KEYS.MACHINE_OLD_NAME, KEYS.MACHINE_OLD_IP, KEYS.MACHINE_OLD_HYP, KEYS.MACHINE_OLD_STATE}, new KEYS[0]);
        public static final Action<MACHINE> CHECK = new Action(MACHINE.class, "CHECK", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<MACHINE> CHECK_STATE = new Action(MACHINE.class, "CHECK_STATE", new KEYS[0], new KEYS[]{KEYS.MACHINE_NAME, KEYS.MACHINE_STATE}, new KEYS[0]);
        public static final Action<MACHINE> RECOVERING_STATE = new Action(MACHINE.class, "RECOVERING_STATE", new KEYS[]{KEYS.MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<MACHINE> NICS_REFRESH = new Action(MACHINE.class, "NICS_REFRESH", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.NETWORK_INTERFACE_NAME, KEYS.VMS_BROKEN});
        public static final Action<MACHINE> VIRTUAL_MACHINE_DELETE = new Action(MACHINE.class, "VIRTUAL_MACHINE_DELETE", new KEYS[]{KEYS.MACHINE_IP}, new KEYS[0], new KEYS[0]);
        public static Action<MACHINE> IMPORT_VIRTUAL_MACHINES = new Action(MACHINE.class, "IMPORT_VIRTUAL_MACHINES", new KEYS[]{KEYS.DISCOVERED_VMS_SIZE, KEYS.NOT_RECOVERED_VMS}, new KEYS[0], new KEYS[0]);
        public static Action<MACHINE> SEND_MAIL = new Action(MACHINE.class, "SEND_MAIL", new KEYS[0], new KEYS[]{KEYS.VMS_MAIL_FAILED, KEYS.USERS_MAIL_FAILED}, new KEYS[0]);
        public static final Action<MACHINE> REFRESH_DATASTORES = new Action(MACHINE.class, "REFRESH_DATASTORES", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.DATASTORE_NAME, KEYS.MACHINE_NAME});
        public static final Action<MACHINE> CLUSTER_DIFFERENT_RACKS = new Action(MACHINE.class, "CLUSTER_DIFFERENT_RACKS", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.MACHINE_NAME, KEYS.CLUSTER_PROVIDER_ID, KEYS.RACK_NAME});
    }

    public static final class LICENSE {
        public static final Action<LICENSE> ADD = new Action(LICENSE.class, "ADD", new KEYS[]{KEYS.NUM_CORES, KEYS.EXPIRATION}, new KEYS[0], new KEYS[0]);
        public static final Action<LICENSE> REMOVE = new Action(LICENSE.class, "REMOVE", new KEYS[]{KEYS.NUM_CORES, KEYS.EXPIRATION}, new KEYS[0], new KEYS[0]);
    }

    public static final class LAYER {
        public static final Action<LAYER> CHECK_CAPACITY = new Action(LAYER.class, "CHECK_CAPACITY", new KEYS[0], new KEYS[0], new KEYS[]{KEYS.LAYER, KEYS.VAPP_NAME, KEYS.DC_NAME, KEYS.RACK_NAME, KEYS.NUM_POSSIBLE_MACHINES, KEYS.MIN_REQUIRED_MACHINES});
        public static final Action<LAYER> REMOVE = new Action(LAYER.class, "REMOVE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class HARD_DISK {
        public static final Action<HARD_DISK> CREATE = new Action(HARD_DISK.class, "CREATE", new KEYS[]{KEYS.VDC_NAME, KEYS.HARD_DISK_SIZE}, new KEYS[0], new KEYS[0]);
        public static final Action<HARD_DISK> MODIFY = new Action(HARD_DISK.class, "MODIFY", new KEYS[]{KEYS.HARD_DISK_OLD_SEQUENCE, KEYS.HARD_DISK_OLD_SIZE, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARD_DISK> MODIFY_PRIMARY = new Action(HARD_DISK.class, "MODIFY_PRIMARY", new KEYS[]{KEYS.HARD_DISK_OLD_SEQUENCE, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARD_DISK> RESIZE = new Action(HARD_DISK.class, "RESIZE", new KEYS[]{KEYS.HARD_DISK_OLD_SEQUENCE, KEYS.HARD_DISK_OLD_SIZE, KEYS.HARD_DISK_SIZE, KEYS.VIRTUAL_MACHINE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<HARD_DISK> DELETE = new Action(HARD_DISK.class, "DELETE", new KEYS[]{KEYS.HARD_DISK_ID, KEYS.VDC_NAME, KEYS.HARD_DISK_SIZE}, new KEYS[0], new KEYS[0]);
    }

    public static final class EXTERNAL_NETWORK {
        public static final Action<EXTERNAL_NETWORK> CREATE = new Action(EXTERNAL_NETWORK.class, "CREATE", new KEYS[]{KEYS.ENT_NAME, KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_NETWORK> GATEWAY_OUT_OF_RANGE = new Action(EXTERNAL_NETWORK.class, "GATEWAY_OUT_OF_RANGE", new KEYS[0], new KEYS[]{KEYS.GATEWAY_OLD}, new KEYS[0]);
        public static final Action<EXTERNAL_NETWORK> DEFAULT = new Action(EXTERNAL_NETWORK.class, "DEFAULT", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_NETWORK> SYNC_CREATE = new Action(EXTERNAL_NETWORK.class, "SYNC_CREATE", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_NETWORK> SYNC_DETACH = new Action(EXTERNAL_NETWORK.class, "SYNC_DETACH", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<EXTERNAL_NETWORK> SYNC_UPDATE = new Action(EXTERNAL_NETWORK.class, "SYNC_UPDATE", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class ENTERPRISE {
        public static final Action<ENTERPRISE> CREATE = new Action(ENTERPRISE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<ENTERPRISE> MODIFY = new Action(ENTERPRISE.class, "MODIFY", new KEYS[]{KEYS.OLD_VALUE, KEYS.NEW_VALUE}, new KEYS[]{KEYS.ENT_OLD_NAME}, new KEYS[0]);
        public static final Action<ENTERPRISE> DELETE = new Action(ENTERPRISE.class, "DELETE", new KEYS[]{KEYS.ENT_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ENTERPRISE> PRICING_TEMPLATE_ASSIGN = new Action(ENTERPRISE.class, "PRICING_TEMPLATE_ASSIGN", new KEYS[]{KEYS.PRICING_TEMPLATE_NAME, KEYS.ENT_OLD_PRICING_TEMPLATE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<ENTERPRISE> DISABLE_WORKFLOW = new Action(ENTERPRISE.class, "DISABLE_WORKFLOW", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<ENTERPRISE> ENABLE_WORKFLOW = new Action(ENTERPRISE.class, "ENABLE_WORKFLOW", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class CURRENCY {
        public static final Action<CURRENCY> CREATE = new Action(CURRENCY.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CURRENCY> MODIFY = new Action(CURRENCY.class, "MODIFY", new KEYS[]{KEYS.CURRENCY_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CURRENCY> DELETE = new Action(CURRENCY.class, "DELETE", new KEYS[]{KEYS.CURRENCY_OLD_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class COSTCODE {
        public static final Action<COSTCODE> CREATE = new Action(COSTCODE.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<COSTCODE> MODIFY = new Action(COSTCODE.class, "MODIFY", new KEYS[]{KEYS.COSTCODE_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<COSTCODE> DELETE = new Action(COSTCODE.class, "DELETE", new KEYS[]{KEYS.COSTCODE_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class CATEGORY {
        public static final Action<CATEGORY> CREATE = new Action(CATEGORY.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<CATEGORY> MODIFY = new Action(CATEGORY.class, "MODIFY", new KEYS[]{KEYS.CATEGORY_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<CATEGORY> DELETE = new Action(CATEGORY.class, "DELETE", new KEYS[]{KEYS.CATEGORY_NAME}, new KEYS[0], new KEYS[0]);
    }

    public static final class DATACENTER_LIMIT {
        public static final Action<DATACENTER_LIMIT> HARD_LIMIT = new Action(DATACENTER_LIMIT.class, "HARD_LIMIT", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class DATACENTER_REPOSITORY {
        public static final Action<DATACENTER_REPOSITORY> REFRESH = new Action(DATACENTER_REPOSITORY.class, "REFRESH", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static final class DATACENTER {
        public static final Action<DATACENTER> CREATE = new Action(DATACENTER.class, "CREATE", new KEYS[0], new KEYS[0], new KEYS[0]);
        public static final Action<DATACENTER> MODIFY = new Action(DATACENTER.class, "MODIFY", new KEYS[]{KEYS.DC_OLD_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATACENTER> DELETE = new Action(DATACENTER.class, "DELETE", new KEYS[]{KEYS.DC_NAME}, new KEYS[0], new KEYS[0]);
        public static final Action<DATACENTER> REMOTE_SERVICES_CREATE = new Action(DATACENTER.class, "REMOTE_SERVICES_CREATE", new KEYS[0], new KEYS[]{KEYS.RS_ERROR}, new KEYS[0]);
        public static final Action<DATACENTER> ENQUEUE_DC_REQUEST = new Action(DATACENTER.class, "ENQUEUE_DC_REQUEST", new KEYS[]{KEYS.COMPONENT_TYPE, KEYS.EVENT, KEYS.REQUEST_TYPE}, new KEYS[0], new KEYS[0]);
        public static final Action<DATACENTER> REQUEST_PRODUCER = new Action(DATACENTER.class, "REQUEST_PRODUCER", new KEYS[]{KEYS.COMPONENT_TYPE, KEYS.EVENT}, new KEYS[0], new KEYS[0]);
        public static final Action<DATACENTER> CLOSE_PRODUCER = new Action(DATACENTER.class, "CLOSE_PRODUCER", new KEYS[0], new KEYS[0], new KEYS[0]);
    }

    public static enum KEYS implements AbiquoKey
    {
        DC_NAME,
        DC_OLD_NAME,
        RS_URI,
        RS_TYPE,
        RS_ERROR,
        DC_REPOSITORY,
        ENT_NAME,
        ENT_ID,
        ENT_OLD_NAME,
        ENT_OLD_PRICING_TEMPLATE_NAME,
        CATEGORY_NAME,
        CATEGORY_OLD_NAME,
        CURRENCY_OLD_NAME,
        TEMPLATE_DEF_LIST_NAME,
        TEMPLATE_DEF_LIST_VALIDATION,
        TEMPLATE_DEFINITION_LIST_OLD_NAME,
        TEMPLATE_NAME,
        TEMPLATE_DISK_FORMAT_TYPE,
        VIRTUAL_MACHINE_TEMPLATE_OLD_NAME,
        VIRTUAL_MACHINE_NAME,
        VIRTUAL_MACHINE_ID,
        VAPP_NAME,
        VAPP_ORIGINAL_NAME,
        VAPP_MOVED_NAME,
        VDC_ORIGIN,
        VDC_DESTINATION,
        VAPP_COPY_NAME,
        NUM_CORES,
        EXPIRATION,
        COSTCODE_NAME,
        PRICING_TEMPLATE_NAME,
        PRICING_TEMPLATE_PRICES,
        ENTERPRISE1,
        ENTERPRISE2,
        TIER_NAME,
        TIER_OLD_NAME,
        MACHINE_NAME,
        MACHINE_IP,
        MACHINE_HYP,
        MACHINE_STATE,
        MACHINE_OLD_NAME,
        MACHINE_OLD_IP,
        MACHINE_OLD_HYP,
        MACHINE_OLD_STATE,
        RACK_NAME,
        RACK_OLD_NAME,
        VMT_MASTER_NAME,
        VMT_PERSISTENT_NAME,
        ROLE_NAME,
        ROLE_OLD_NAME,
        ROLE_OLD_ENT,
        PRIVILEGES_ADDED,
        PRIVILEGES_DELETED,
        VDC_NAME,
        VLAN_NAME,
        VLAN_TYPE,
        VLAN_TAG,
        INITIATORIQN,
        NETWORK_INTERFACE_NAME,
        SERVICE_PROFILE,
        VMS_BROKEN,
        CONNECTION_ENDPOINT,
        CONNECTION_IDENTITY,
        VOLUME_NAME,
        VOLUME_SIZE,
        VOLUME_UUID,
        VNIC_IP,
        HYPERVISOR_NAME,
        HYPERVISOR_IP,
        BLADE,
        ROLE_LDAP,
        ROLE_LDAP_OLD,
        SCOPE_NAME,
        USER_OLD_NAME,
        USER_NAME,
        USER_SURNAME,
        USER_NICK,
        RUN_LIST_SIZE,
        RUN_LIST_ELEMENT,
        IP,
        VLAN_NETWORK_NAME,
        NST_NAME,
        IP_ADDRESSES,
        PRIVATE_NET_ID,
        PRIVATE_NET_NAME,
        PRIVATE_NET_OLD_NAME,
        EXTERNAL_NET_ID,
        PUBLIC_NET_NAME,
        PUBLIC_NET_ID,
        PUBLIC_NET_OLD_NAME,
        PUBLIC_NET_TYPE,
        EXCLUDED_NET_OLD_NAME,
        HARD_DISK_SIZE,
        HARD_DISK_ID,
        HARD_DISK_OLD_SEQUENCE,
        HARD_DISK_OLD_SIZE,
        COMPONENT_TYPE,
        EVENT,
        REQUEST_TYPE,
        RASD_LIMIT,
        DISK_SIZE,
        STORAGE_DEVICE_NAME,
        STORAGE_DEVICE_OLD_NAME,
        VOLUME_OLD_NAME,
        VOLUME_OLD_SIZE,
        STORAGE_POOL_NAME,
        DISK_TYPE,
        HYPERVISOR_TYPE,
        NUM_POSSIBLE_MACHINES,
        MIN_REQUIRED_MACHINES,
        CANDIDATES_SIZE,
        REQUIREMENTS_CPU,
        REQUIREMENTS_RAM,
        CANDIDATES_NAMES,
        TASK_ID,
        TASK_OWNER_ID,
        NOTIFICATION,
        VIRTUAL_MACHINE_STATE,
        TASK_TYPE,
        HANDLER_NAME,
        EXCEPTION_CLASS,
        TASK_ERROR,
        TASK_OWNER,
        TASK_TIMESTAMP,
        JOB_TYPE,
        CONVERSION_TARGET_PATH,
        CONVERSION_SOURCE_TYPE,
        CONVERSION_TARGET_TYPE,
        DATASTORE_NAME,
        VIRTUAL_MACHINE_TEMPLATE_NAME,
        DC_ID,
        OVFID,
        NICS_PER_VM,
        OLD_VM_IPS,
        NEW_VM_IPS,
        CLONED_VM_MACHINE_NAME,
        ROOT_PATH,
        LAYER,
        CAUSE,
        CURRENT_NICS_SIZE,
        REQUESTED_NICS_SIZE,
        DISCOVERED_VMS_SIZE,
        NOT_RECOVERED_VMS,
        LIMIT_MESSAGE,
        LOADLEVEL_MESSAGE,
        OTHER_HYPERVISOR_NAME,
        OTHER_HYPERVISOR_IP,
        CORES_PER_SOCKET,
        RAM,
        CPU,
        DVD,
        EXTRA_RECONFIGURE_MESSAGE,
        PCR_NAME,
        PCR_ENDPOINT,
        PCR_REGION,
        PCR_OLD_NAME,
        PCR_OLD_ENDPOINT,
        APPLICATION_NAME,
        POLICY_NAME,
        POLICY_OLD_NAME,
        OLD_VALUE,
        NEW_VALUE,
        DISABLE_WORKFLOW,
        ENABLE_WORKFLOW,
        ROUTING_RULE_PORT_IN,
        ROUTING_RULE_PORT_OUT,
        LOAD_BALANCER_NAME,
        HEALTH_CHECK_NAME,
        LOAD_BALANCER_OLD_NAME,
        LOAD_BALANCER_ADDRESS_ENDPOINT,
        LOAD_BALANCER_ADDRESS_PROVIDERID,
        LOADBALANCE_TYPE,
        VMS_MAIL_FAILED,
        USERS_MAIL_FAILED,
        BACKUP_ID,
        BACKUP_NAME,
        RESTORE_STATUS,
        BACKUP_DATE,
        BACKUP_SIZE,
        BACKUP_TYPE,
        BACKUP_STATUS,
        DISK_LABEL,
        DISK_PATH,
        DISK_SEQUENCE,
        DISKS_LABEL,
        DISK_CONTROLLER,
        DISK_CONTROLLER_DEFAULT,
        LOCATION_NAME,
        DATASTORE_TIER_NAME,
        FIREWALL_NAME,
        GATEWAY_OLD,
        GATEWAY_NEW,
        SPEC_NAME,
        ALARM_NAME,
        ALERT_NAME,
        FIREWALL_ID,
        LOAD_BALANCER_ID,
        VOLUME_ID,
        VNIC_MAC,
        VNIC_TAG_DB,
        VNIC_TAG_PROVIDER,
        DISK_URL,
        VOLUME_URL,
        SCALING_GROUP_NAME,
        SCALING_GROUP_ADJUSTMENT,
        HP_ABS_DC_NAME,
        HP_ABS_DC_OLD_NAME,
        HP_NAME,
        HP_OLD_NAME,
        BACKUP_POLICY_NAME,
        ACTION_PLAN_NAME,
        PROVIDER_ID,
        ACTION_PLAN_EXECUTION_INITIATOR,
        GUEST_SETUP,
        VIRTUAL_MACHINE_FQDN,
        CLUSTER_PROVIDER_ID,
        ENTITY_TYPE,
        ENTITY_NAME,
        NAT_NET_NAME,
        NAT_IP,
        NAT_PORT_ORIGINAL,
        NAT_PORT_TRANSLATED,
        NAT_SNAT,
        QUARANTINE,
        BILL_PERIOD_START,
        BILL_PERIOD_END,
        BILL_PROVIDER,
        BILL_DATE,
        LIMIT_ID,
        VPN_NAME,
        VPN_OLD_NAME;

    }
}

