/**
 * Copyright (C) 2008 - Abiquo Holdings S.L. All rights reserved.
 *
 * Please see /opt/abiquo/tomcat/webapps/legal/ on Abiquo server
 * or contact contact@abiquo.com for licensing information.
 */
package com.abiquo.vsm.model.transport;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "console")
@XmlType(propOrder = {"check", "about", "monitors", "subscriptions"})
public class ConsoleDto
{
    @XmlElement
    private MonitorsDto monitors;

    @XmlElement
    private SubscriptionsDto subscriptions;

    private AboutDto about;

    private CheckDto check;

    public ConsoleDto()
    {
        monitors = new MonitorsDto();
        subscriptions = new SubscriptionsDto();
    }

    public MonitorsDto getMonitors()
    {
        return monitors;
    }

    public SubscriptionsDto getSubscriptions()
    {
        return subscriptions;
    }

    public AboutDto getAbout()
    {
        return about;
    }

    public void setAbout(AboutDto about)
    {
        this.about = about;
    }

    public CheckDto getCheck()
    {
        return check;
    }

    public void setCheck(CheckDto check)
    {
        this.check = check;
    }
}
