/**
 * Copyright (C) 2008 - Abiquo Holdings S.L. All rights reserved.
 *
 * Please see /opt/abiquo/tomcat/webapps/legal/ on Abiquo server
 * or contact contact@abiquo.com for licensing information.
 */
package com.abiquo.vsm.model.transport;

import static com.google.common.base.Objects.toStringHelper;
import static com.google.common.base.Strings.emptyToNull;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.CompareToBuilder;

@XmlRootElement(name = "monitor")
public class MonitorDto implements Comparable<MonitorDto>
{
    private Long id;

    private String type;

    private String uniqueIdentifier;

    private String endPoint;

    private String ip;

    private Integer port;

    private String user;

    private String password;

    private String managerIp;

    private Integer managerPort;

    private String managerUser;

    private String managerPassword;

    private String agentIp;

    private Integer agentPort;

    private String agentUser;

    private String agentPassword;

    public Long getId()
    {
        return id;
    }

    public void setId(final Long id)
    {
        this.id = id;
    }

    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    public String getIp()
    {
        return ip;
    }

    public void setIp(final String ip)
    {
        this.ip = ip;
    }

    public Integer getPort()
    {
        return port;
    }

    public void setPort(final Integer port)
    {
        this.port = port;
    }

    public String getManagerIp()
    {
        return managerIp;
    }

    public void setManagerIp(final String managerIp)
    {
        this.managerIp = managerIp;
    }

    public Integer getManagerPort()
    {
        return managerPort;
    }

    public void setManagerPort(final Integer managerPort)
    {
        this.managerPort = managerPort;
    }

    public String getAgentIp()
    {
        return agentIp;
    }

    public void setAgentIp(final String agentIp)
    {
        this.agentIp = agentIp;
    }

    public Integer getAgentPort()
    {
        return agentPort;
    }

    public void setAgentPort(final Integer agentPort)
    {
        this.agentPort = agentPort;
    }

    public String getUser()
    {
        return user;
    }

    public void setUser(final String user)
    {
        this.user = user;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(final String password)
    {
        this.password = password;
    }

    public String getManagerUser()
    {
        return managerUser;
    }

    public void setManagerUser(final String managerUser)
    {
        this.managerUser = managerUser;
    }

    public String getManagerPassword()
    {
        return managerPassword;
    }

    public void setManagerPassword(final String managerPassword)
    {
        this.managerPassword = managerPassword;
    }

    public String getAgentUser()
    {
        return agentUser;
    }

    public void setAgentUser(final String agentUser)
    {
        this.agentUser = agentUser;
    }

    public String getAgentPassword()
    {
        return agentPassword;
    }

    public void setAgentPassword(final String agentPassword)
    {
        this.agentPassword = agentPassword;
    }

    public String getEndPoint()
    {
        return endPoint;
    }

    public void setEndPoint(final String endPoint)
    {
        this.endPoint = endPoint;
    }

    public String getUniqueIdentifier()
    {
        return uniqueIdentifier;
    }

    public void setUniqueIdentifier(final String uniqueIdentifier)
    {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    @Override
    public int compareTo(final MonitorDto that)
    {
        return new CompareToBuilder().append(this.id, that.id).toComparison();
    }

    @Override
    public String toString()
    {
        return toStringHelper(this).omitNullValues().add("Id", getId())
            .add("UID", emptyToNull(getUniqueIdentifier())).add("Type", emptyToNull(getType()))
            .add("End point", emptyToNull(getEndPoint())).add("Host ip", emptyToNull(getIp()))
            .add("Host port", getPort()).add("Manager ip", emptyToNull(getManagerIp()))
            .add("Manager port", getManagerPort()).add("Agent ip", emptyToNull(getAgentIp()))
            .add("Agent port", getAgentPort()).toString();
    }
}
