/**
 * Copyright (C) 2008 - Abiquo Holdings S.L. All rights reserved.
 *
 * Please see /opt/abiquo/tomcat/webapps/legal/ on Abiquo server
 * or contact contact@abiquo.com for licensing information.
 */
package com.abiquo.vsm.model.transport;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.CompareToBuilder;

@XmlRootElement(name = "subscription")
public class SubscriptionDto implements Comparable<SubscriptionDto>
{
    private Long id;

    private String uuid;

    private String notified;

    private MonitorDto monitor;

    private boolean monitored;

    public Long getId()
    {
        return id;
    }

    public void setId(final Long id)
    {
        this.id = id;
    }

    public String getUuid()
    {
        return uuid;
    }

    public void setUuid(final String uuid)
    {
        this.uuid = uuid;
    }

    public String getNotified()
    {
        return notified;
    }

    public void setNotified(final String notified)
    {
        this.notified = notified;
    }

    public MonitorDto getMonitor()
    {
        return monitor;
    }

    public void setMonitor(final MonitorDto monitor)
    {
        this.monitor = monitor;
    }

    public boolean isMonitored()
    {
        return monitored;
    }

    public void setMonitored(final boolean monitored)
    {
        this.monitored = monitored;
    }

    @Override
    public int compareTo(final SubscriptionDto that)
    {
        return new CompareToBuilder().append(this.id, that.id).toComparison();
    }
}
