/**
 * Copyright (C) 2008 - Abiquo Holdings S.L. All rights reserved.
 *
 * Please see /opt/abiquo/tomcat/webapps/legal/ on Abiquo server
 * or contact contact@abiquo.com for licensing information.
 */
package com.abiquo.vsm.model.transport;

public enum SubscriptionUpdateType
{
    /** Set the subscription last known state to {@link VMEventType#UNKNOWN} */
    RESET,

    /** Set the subscription last known state to {@link VMEventType#UNKNOWN} and refresh it */
    REFRESH,

    /**
     * Set the subscription last known state to {@link VMEventType#UNKNOWN} and refresh it if the
     * virtual machine exist in the hypervisor. If not exists a {@link VMEventType#DESTROYED} is
     * notified.
     */
    CHECK_EXISTENCE_AND_REFRESH,

    /**
     * Performs a {@link SubscriptionUpdateType#REFRESH} and forces the execution of a
     * {@link VirtualMachineDefinitionSyncNoScheduleOp} operation.
     */
    REFRESH_AND_FORCE_VM_DEF_SYNC,

    /**
     * Forces the execution of a {@link VirtualMachineDefinitionSyncNoScheduleOp} operation.
     */
    FORCE_VM_DEF_SYNC,

    ENABLE_MONITORING,

    DISABLE_MONITORING;
}
