/**
 * Copyright (C) 2008 - Abiquo Holdings S.L. All rights reserved.
 *
 * Please see /opt/abiquo/tomcat/webapps/legal/ on Abiquo server
 * or contact contact@abiquo.com for licensing information.
 */
package com.abiquo.vsm.model.transport;

import java.io.Serializable;

import com.google.common.base.Objects;

public class VirtualSystemEvent implements Serializable
{
    private static final long serialVersionUID = 5685873169202454346L;

    protected String monitorUid;

    protected String virtualMachineUuid;

    protected String event;

    public VirtualSystemEvent()
    {

    }

    public VirtualSystemEvent(final String virtualMachineUuid, final String monitorUid,
        final String event)
    {
        this.virtualMachineUuid = virtualMachineUuid;
        this.monitorUid = monitorUid;
        this.event = event;
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(virtualMachineUuid, monitorUid, event);
    }

    @Override
    public boolean equals(final Object obj)
    {
        if (obj instanceof VirtualSystemEvent)
        {
            final VirtualSystemEvent other = (VirtualSystemEvent) obj;
            return Objects.equal(event, other.event) && //
                Objects.equal(monitorUid, other.monitorUid) && //
                Objects.equal(event, other.event);
        }
        else
        {
            return false;
        }
    }

    public String getMonitorUid()
    {
        return monitorUid;
    }

    public void setMonitorUid(final String monitorUid)
    {
        this.monitorUid = monitorUid;
    }

    public String getVirtualMachineUuid()
    {
        return virtualMachineUuid;
    }

    public void setVirtualMachineUuid(final String virtualMachineUuid)
    {
        this.virtualMachineUuid = virtualMachineUuid;
    }

    public String getEvent()
    {
        return event;
    }

    public void setEvent(final String event)
    {
        this.event = event;
    }
}
