/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.cli.ParseException;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.util.webserver.ParametersExtractor;
import org.kawanfw.sql.api.util.webserver.WebServerApiWrapper;
import org.kawanfw.sql.api.util.webserver.WebServerUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.SqlTag;
import org.kawanfw.sql.version.VersionWrapper;

public class WebServer {
    private static boolean DEBUG = FrameworkDebug.isSet(WebServer.class);

    protected WebServer() {
    }

    public static void main(String[] args) throws ParseException, IOException, ConnectException, DatabaseConfigurationException {
        ParametersExtractor parametersExtractor;
        if (args.length > 0) {
            WebServer.debug("args[0]: " + args[0] + ":");
        }
        if (args.length > 1) {
            WebServer.debug("args[1]: " + args[1] + ":");
        }
        if ((parametersExtractor = new ParametersExtractor(args)).isStartCommand()) {
            WebServer.doStart(parametersExtractor);
        } else {
            WebServer.doStop(parametersExtractor);
        }
    }

    private static void doStart(ParametersExtractor parametersExtractor) {
        String host = parametersExtractor.getHost();
        File propertiesFile = parametersExtractor.getPropertiesFile();
        int port = parametersExtractor.getPort();
        WebServerApiWrapper webServerApiWrapper = new WebServerApiWrapper();
        try {
            webServerApiWrapper.startServer(host, port, propertiesFile);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START_FAILURE) + " " + "[USER CONFIGURATION]" + " " + e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
        catch (ConnectException e) {
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START_FAILURE) + " " + e.getMessage());
            e.printStackTrace();
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
        catch (UnknownHostException e) {
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START_FAILURE) + " " + "Unknow host: " + e.getMessage());
            WebServerUtil.printCauseException(e);
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START_FAILURE) + " " + e.getMessage());
            WebServerUtil.printCauseException(e);
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
        catch (Exception e) {
            System.err.println(SqlTag.SQL_PRODUCT_START_FAILURE);
            e.printStackTrace();
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
    }

    private static void doStop(ParametersExtractor parametersExtractor) {
        int port = parametersExtractor.getPort();
        WebServerApiWrapper webServerApiWrapper = new WebServerApiWrapper();
        try {
            webServerApiWrapper.stopServer(port);
            System.out.println(String.valueOf(VersionWrapper.getName()) + " Web server running on port " + port + " successfully stopped!");
            System.out.println();
            WebServerUtil.systemExitWrapper(0);
        }
        catch (ConnectException e) {
            System.err.println(e.getMessage());
            System.err.println();
            WebServerUtil.systemExitWrapper(-1);
        }
        catch (IOException e) {
            System.err.println("Impossible to stop the SQL Web server running on port " + port);
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                System.err.println("Java Exception Stack Trace:");
                e.printStackTrace();
            }
            System.err.println();
            WebServerUtil.systemExitWrapper(0);
        }
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

