/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.parser.SqlCommentsDetector;
import org.kawanfw.sql.util.parser.SqlStringTokenizer;

public class BasicSqlInjectionAnalyser {
    private static boolean DEBUG = FrameworkDebug.isSet(BasicSqlInjectionAnalyser.class);
    private String sql;
    private boolean detectLineBreaks = true;
    private boolean detectComments = true;
    private boolean detectSeparators = true;
    private boolean detectTabs = true;
    private boolean detectDoubleQuotes = true;
    private boolean detectNoSpaces = true;
    private Set<String> forbiddenKeywordList = new LinkedHashSet<String>();
    private boolean withLineBreaks;
    private boolean withComments;
    private boolean withSeparators;
    private boolean withTabs;
    private boolean withDoubleQuotes;
    private boolean withNoSpaces;
    private boolean withForbiddenKeywords;
    private boolean withOddQuotesNumber;
    private String keywordDetected;
    private boolean withNestedComments;
    private boolean withEqualValuesAroundEqual;
    private String anomalyDetected;

    public BasicSqlInjectionAnalyser(String sql) {
        Objects.requireNonNull(sql, "sql cannot be null!");
        this.sql = sql;
    }

    public void setDetectTabs(boolean detectTabs) {
        this.detectTabs = detectTabs;
    }

    public void setDetectSeparators(boolean detectSeparators) {
        this.detectSeparators = detectSeparators;
    }

    public void setDetectLineBreaks(boolean detectLineBreaks) {
        this.detectLineBreaks = detectLineBreaks;
    }

    public void setDetectComments(boolean detectComments) {
        this.detectComments = detectComments;
    }

    public void setDetectDoubleQuotes(boolean detectDoubleQuotes) {
        this.detectDoubleQuotes = detectDoubleQuotes;
    }

    public void setDetectNoSpaces(boolean detectNoSpaces) {
        this.detectNoSpaces = detectNoSpaces;
    }

    public void setForbiddenKeywordList(Set<String> forbiddenKeywordList) {
        Objects.requireNonNull(forbiddenKeywordList, "forbiddenKeywordList cannot be null!");
        this.forbiddenKeywordList = forbiddenKeywordList;
    }

    public String getAnomalyDetected() {
        return this.anomalyDetected;
    }

    public boolean isWithNestedComments() {
        return this.withNestedComments;
    }

    public boolean isWithLineBreaks() {
        return this.withLineBreaks;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public boolean isWithSeparators() {
        return this.withSeparators;
    }

    public boolean isWithForbiddenKeywords() {
        return this.withForbiddenKeywords;
    }

    public boolean isWithEqualValuesAroundEqual() {
        return this.withEqualValuesAroundEqual;
    }

    public boolean isSqlInjectionSuspect() {
        if (this.withEqualValuesAroundEqual) {
            return true;
        }
        if (this.detectComments && this.withComments) {
            return true;
        }
        if (this.detectLineBreaks && this.withLineBreaks) {
            return true;
        }
        if (this.detectSeparators && this.withSeparators) {
            return true;
        }
        if (this.detectTabs && this.withTabs) {
            return true;
        }
        if (this.withForbiddenKeywords) {
            return true;
        }
        if (this.detectDoubleQuotes && this.withDoubleQuotes) {
            return true;
        }
        return this.detectNoSpaces && this.withNoSpaces;
    }

    public void analyse() {
        this.initResults();
        if (this.detectNoSpaces && !this.sql.trim().contains(" ")) {
            this.withNoSpaces = true;
            this.anomalyDetected = "SqlWithNoSpaces";
        }
        this.withNestedComments = BasicSqlInjectionAnalyser.containsNestedComments(this.sql);
        if (this.withNestedComments) {
            this.anomalyDetected = "SqlWithNestedComments";
            return;
        }
        if (this.detectLineBreaks && BasicSqlInjectionAnalyser.checkIfStringContainsNewLineCharacters(this.sql)) {
            this.anomalyDetected = "SqlWithLineBreaks";
            this.withLineBreaks = true;
            return;
        }
        SqlCommentsDetector sqlCommentsDetector = new SqlCommentsDetector(this.sql);
        this.sql = sqlCommentsDetector.removeComments();
        this.withComments = sqlCommentsDetector.isWithComments();
        if (this.detectComments && this.withComments) {
            this.anomalyDetected = "SqlWithComments";
            return;
        }
        BasicSqlInjectionAnalyser.debug("sql after remove comments: " + this.sql);
        BasicSqlInjectionAnalyser.debug("this.withComments        : " + this.withComments);
        int singleQuoteQuantity = StringUtils.countMatches((CharSequence)this.sql, (CharSequence)"'");
        if (singleQuoteQuantity % 2 != 0) {
            this.withOddQuotesNumber = true;
            this.anomalyDetected = "SqlWithOddQuotesNumber";
            return;
        }
        if (BasicSqlInjectionAnalyser.hasEqualValuesAroundEqual(this.sql)) {
            this.withEqualValuesAroundEqual = true;
            this.anomalyDetected = "SqlWithEqualValuesAroundEqual";
            return;
        }
        List<String> tokens = SqlStringTokenizer.getTokensSplitOnSinglesQuotes(this.sql);
        BasicSqlInjectionAnalyser.debug("Split on quotes - display 2:");
        int i = 0;
        while (i < tokens.size()) {
            boolean injectionDetected;
            BasicSqlInjectionAnalyser.debug(String.valueOf(i) + ": " + tokens.get(i));
            if (i % 2 == 0 && (injectionDetected = this.analyseDeep(tokens.get(i)))) {
                return;
            }
            ++i;
        }
    }

    private void initResults() {
        this.withLineBreaks = false;
        this.withComments = false;
        this.withSeparators = false;
        this.withTabs = false;
        this.withForbiddenKeywords = false;
        this.withOddQuotesNumber = false;
        this.keywordDetected = null;
        this.withNestedComments = false;
        this.withEqualValuesAroundEqual = false;
        this.withDoubleQuotes = false;
        this.withNoSpaces = false;
        this.anomalyDetected = null;
    }

    public boolean isWithOddQuotesNumber() {
        return this.withOddQuotesNumber;
    }

    private boolean analyseDeep(String sqlTokens) {
        if (this.detectComments && (sqlTokens.contains("--") || sqlTokens.contains("#"))) {
            this.withComments = true;
            this.anomalyDetected = "SqlWithComments";
            return true;
        }
        if (this.detectSeparators && sqlTokens.contains(";")) {
            this.withSeparators = true;
            this.anomalyDetected = "SqlWithSeparators";
            return true;
        }
        if (this.detectTabs && sqlTokens.contains("\t")) {
            this.withTabs = true;
            this.anomalyDetected = "SqlWithTabs";
            return true;
        }
        if (this.detectDoubleQuotes && sqlTokens.contains("\"")) {
            this.withDoubleQuotes = true;
            this.anomalyDetected = "SqlWithDoubleQuotes";
            return true;
        }
        if (this.containsForbiddenKeywords(sqlTokens)) {
            this.withForbiddenKeywords = true;
            this.anomalyDetected = "SqlWithForbiddenKeywords. Keyword detected: " + this.keywordDetected;
            return true;
        }
        return false;
    }

    public static boolean hasEqualValuesAroundEqual(String sqlTokens) {
        String sqlTokensNew = sqlTokens;
        while (sqlTokensNew.contains("= ")) {
            sqlTokensNew = StringUtils.replace((String)sqlTokensNew, (String)"= ", (String)"=");
        }
        while (sqlTokensNew.contains(" =")) {
            sqlTokensNew = StringUtils.replace((String)sqlTokensNew, (String)" =", (String)"=");
        }
        List<String> tokens = BasicSqlInjectionAnalyser.getTokensSplitOnEquals(sqlTokensNew);
        boolean injectionDetected = false;
        int i = 0;
        while (i < tokens.size()) {
            String previousValue;
            String currentValue;
            BasicSqlInjectionAnalyser.debug("hasEqualValuesAroundEqual " + i + ": " + tokens.get(i));
            if (i != 0 && (currentValue = StringUtils.substringBefore((String)tokens.get(i), (String)" ").trim()).equals(previousValue = StringUtils.substringAfterLast((String)tokens.get(i - 1).trim(), (String)" ").trim())) {
                BasicSqlInjectionAnalyser.debug("Injection on: " + previousValue + "=" + currentValue);
                injectionDetected = true;
            }
            ++i;
        }
        return injectionDetected;
    }

    private static List<String> getTokensSplitOnEquals(String sql) {
        Objects.requireNonNull(sql, "sql cannot be null!");
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(sql, "=", false);
        while (stringTokenizer.hasMoreElements()) {
            tokens.add(stringTokenizer.nextToken());
        }
        return tokens;
    }

    public static boolean containsNestedComments(String sql) {
        String[] stringArray;
        Objects.requireNonNull(sql, "sql cannot be null!");
        String[] stringArray2 = stringArray = sql.split("/\\*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            BasicSqlInjectionAnalyser.debug("Split on /*: " + string);
            if (!(StringUtils.countMatches((CharSequence)string, (CharSequence)"*/") <= 1 || string.contains("'") && string.indexOf("'") > StringUtils.lastIndexOf((CharSequence)string, (CharSequence)"*/"))) {
                BasicSqlInjectionAnalyser.debug("Contains > 1 */");
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean containsForbiddenKeywords(String sqlTokens) {
        String sqlTokensNew = sqlTokens;
        if (StringUtils.lastIndexOf((CharSequence)(sqlTokensNew = sqlTokensNew.trim().toLowerCase()), (CharSequence)"#") > StringUtils.lastIndexOf((CharSequence)sqlTokensNew, (CharSequence)"'")) {
            sqlTokensNew = StringUtils.substringBeforeLast((String)sqlTokensNew, (String)"#");
        }
        if (StringUtils.lastIndexOf((CharSequence)sqlTokensNew, (CharSequence)"--") > StringUtils.lastIndexOf((CharSequence)sqlTokensNew, (CharSequence)"'")) {
            sqlTokensNew = StringUtils.substringBeforeLast((String)sqlTokensNew, (String)"--");
        }
        for (String keyword : this.forbiddenKeywordList) {
            if (!sqlTokensNew.contains(keyword.toLowerCase())) continue;
            this.keywordDetected = keyword;
            return true;
        }
        return false;
    }

    private static boolean checkIfStringContainsNewLineCharacters(String str) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            Scanner scanner = new Scanner(str);
            scanner.nextLine();
            boolean hasNextLine = scanner.hasNextLine();
            scanner.close();
            return hasNextLine;
        }
        return false;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

