/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.logging.DefaultLoggerCreator;
import org.kawanfw.sql.api.server.util.UsernameConverter;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class DefaultDatabaseConfigurator
implements DatabaseConfigurator {
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    protected boolean flattenLogMessages = true;
    private Map<String, DataSource> dataSourceSet = new ConcurrentHashMap<String, DataSource>();
    private Properties properties = null;
    private static Logger ACEQL_LOGGER = null;
    private static Map<String, String> LOGGER_ELEMENTS = new ConcurrentHashMap<String, String>();

    @Override
    public Connection getConnection(String database) throws SQLException {
        DataSource dataSource = this.dataSourceSet.get(database);
        if (dataSource == null) {
            dataSource = TomcatSqlModeStore.getDataSource(database);
            if (dataSource == null) {
                if (TomcatSqlModeStore.isTomcatEmbedded()) {
                    String message = String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " the \"driverClassName\" property is not defined in the properties file for database " + database + " or the Db Vendor is not supported in this version.";
                    throw new SQLException(message);
                }
                String message = String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " the \"driverClassName\" property is not defined in the properties file for database " + database + " or the servlet name does not match the url pattern in your web.xml";
                throw new SQLException(message);
            }
            this.dataSourceSet.put(database, dataSource);
        }
        Connection connection = dataSource.getConnection();
        return connection;
    }

    @Override
    public void close(Connection connection) throws SQLException {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            try {
                Logger logger = this.getLogger();
                LoggerWrapper.log(logger, "Error on close(): ", e);
            }
            catch (Exception io) {
                io.printStackTrace();
            }
        }
    }

    @Override
    public int getMaxRows(String username, String database) throws IOException, SQLException {
        int maxRows = 0;
        this.setProperties();
        String maxRowsStr = this.properties.getProperty("defaultDatabaseConfigurator.maxRows");
        if (maxRowsStr == null) {
            return 0;
        }
        if (!StringUtils.isNumeric((CharSequence)maxRowsStr)) {
            throw new IllegalArgumentException("The defaultDatabaseConfigurator.maxRows property is not numeric: " + maxRowsStr);
        }
        maxRows = Integer.parseInt(maxRowsStr);
        return maxRows;
    }

    @Override
    public long getMaxBlobLength(String username, String database) throws IOException, SQLException {
        long maxBlobLength = 0L;
        this.setProperties();
        String maxBlobLengthStr = this.properties.getProperty("defaultDatabaseConfigurator.maxBlobLength");
        if (maxBlobLengthStr == null) {
            return 0x80000000L;
        }
        try {
            maxBlobLength = Long.parseLong(maxBlobLengthStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The defaultDatabaseConfigurator.maxBlobLength property is not a long value: " + maxBlobLengthStr);
        }
        return maxBlobLength;
    }

    @Override
    public File getBlobsDirectory(String username) throws IOException, SQLException {
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome = String.valueOf(userHome) + File.separator;
        }
        String usernameNew = UsernameConverter.fromSpecialChars(username);
        userHome = String.valueOf(userHome) + ".aceql-server-root" + File.separator + usernameNew;
        File userHomeDir = new File(userHome);
        userHomeDir.mkdirs();
        return userHomeDir;
    }

    @Override
    public Logger getLogger() throws IOException {
        if (ACEQL_LOGGER != null) {
            return ACEQL_LOGGER;
        }
        DefaultLoggerCreator defaultLoggerCreator = new DefaultLoggerCreator();
        ACEQL_LOGGER = defaultLoggerCreator.getLogger();
        LOGGER_ELEMENTS = defaultLoggerCreator.getElements();
        return ACEQL_LOGGER;
    }

    public static Map<String, String> getLoggerElements() {
        return LOGGER_ELEMENTS;
    }

    private void setProperties() throws IOException, DatabaseConfigurationException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
    }
}

