/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.kawanfw.sql.api.server.DataSourceStore;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.sql.json_return.ExceptionReturner;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.util.FrameworkDebug;

public class DefaultPoolsInfo
extends HttpServlet {
    private static final long serialVersionUID = 6129302507495768396L;
    private static boolean DEBUG = FrameworkDebug.isSet(DefaultPoolsInfo.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.executeRequest(request, response);
    }

    private void executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            this.executeRequestInTryCatch(request, response, (OutputStream)out);
        }
        catch (Exception e) {
            ExceptionReturner.logAndReturnException(request, response, (OutputStream)out, (Throwable)e);
        }
    }

    private void executeRequestInTryCatch(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException, SQLException, FileUploadException {
        DefaultPoolsInfo.debug("Starting...");
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=UTF-8");
        String password = request.getParameter("password");
        if (password == null || password.isEmpty()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 403, 3, "Invalid username or password.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return;
        }
        String storedPassword = null;
        try {
            File file = new File(String.valueOf(SystemUtils.USER_HOME) + File.separator + ".kawansoft" + File.separator + "default_pools_info.properties");
            Properties properties = new Properties();
            Throwable throwable = null;
            Object var9_13 = null;
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            storedPassword = properties.getProperty("password");
            if (storedPassword == null || storedPassword.isEmpty()) {
                storedPassword = FileUtils.readFileToString((File)new File(String.valueOf(SystemUtils.USER_HOME) + File.separator + ".kawansoft" + File.separator + "default_pools_info_password.txt"), (String)"UTF-8");
            }
            DefaultPoolsInfo.debug("stored_password: " + storedPassword + ":");
            if (storedPassword == null || !storedPassword.trim().equals(password)) {
                throw new IllegalArgumentException("Invalid username or password.");
            }
        }
        catch (Exception e) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 403, 3, "Invalid username or password.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return;
        }
        String setDatabase = request.getParameter("database");
        Map<String, javax.sql.DataSource> dataSources = DataSourceStore.getDataSources();
        if (dataSources == null || dataSources.isEmpty()) {
            JsonErrorReturn errorReturn = new JsonErrorReturn(response, 400, 2, "No databases have been defined in \"Tomcat JDBC Connection Pool Section\" in properties file.");
            ServerSqlManager.writeLine(out, errorReturn.build());
            return;
        }
        this.writeOutpuMain(request, out, setDatabase, dataSources);
    }

    private void writeOutpuMain(HttpServletRequest request, OutputStream out, String setDatabase, Map<String, javax.sql.DataSource> dataSources) throws NumberFormatException, IOException {
        StringWriter writer = new StringWriter();
        JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(true);
        JsonGenerator gen = jf.createGenerator((Writer)writer);
        Set<String> databases = dataSources.keySet();
        gen.writeStartObject();
        gen.write("status", "OK");
        gen.write("see", "https://tomcat.apache.org/tomcat-9.0-doc/api/org/apache/tomcat/jdbc/pool/DataSourceProxy.html");
        gen.writeStartArray("databases");
        for (String database : databases) {
            this.writeOutputElementInLoop(request, setDatabase, dataSources, gen, database);
        }
        gen.writeEnd();
        gen.writeEnd();
        gen.close();
        String outString = writer.toString();
        ServerSqlManager.writeLine(out, outString);
    }

    private void writeOutputElementInLoop(HttpServletRequest request, String setDatabase, Map<String, javax.sql.DataSource> dataSources, JsonGenerator gen, String database) throws NumberFormatException {
        javax.sql.DataSource datasource = dataSources.get(database);
        DataSource dataSourceProxy = (DataSource)datasource;
        if (setDatabase == null || setDatabase.equals(database)) {
            String doSet = request.getParameter("setMinIdle");
            if (doSet != null && !doSet.isEmpty() && StringUtils.isNumeric((CharSequence)doSet) && StringUtils.isNumeric((CharSequence)doSet)) {
                dataSourceProxy.setMinIdle(Integer.parseInt(doSet));
            }
            if ((doSet = request.getParameter("setMaxIdle")) != null && !doSet.isEmpty() && StringUtils.isNumeric((CharSequence)doSet) && StringUtils.isNumeric((CharSequence)doSet)) {
                dataSourceProxy.setMaxIdle(Integer.parseInt(doSet));
            }
            if ((doSet = request.getParameter("setMaxActive")) != null && !doSet.isEmpty() && StringUtils.isNumeric((CharSequence)doSet) && StringUtils.isNumeric((CharSequence)doSet)) {
                dataSourceProxy.setMaxActive(Integer.parseInt(doSet));
            }
        }
        gen.writeStartObject().write("database", database).writeEnd();
        gen.writeStartObject().write("getBorrowedCount()", dataSourceProxy.getBorrowedCount()).writeEnd();
        gen.writeStartObject().write("getMaxActive()", dataSourceProxy.getMaxActive()).writeEnd();
        gen.writeStartObject().write("getMaxIdle()", dataSourceProxy.getMaxIdle()).writeEnd();
        gen.writeStartObject().write("getMinIdle()", dataSourceProxy.getMinIdle()).writeEnd();
        gen.writeStartObject().write("getNumActive()", dataSourceProxy.getNumActive()).writeEnd();
        gen.writeStartObject().write("getNumIdle()", dataSourceProxy.getNumIdle()).writeEnd();
        gen.writeStartObject().write("getReconnectedCount()", dataSourceProxy.getReconnectedCount()).writeEnd();
        gen.writeStartObject().write("getReleasedCount()", dataSourceProxy.getReleasedCount()).writeEnd();
        gen.writeStartObject().write("getReleasedIdleCount()", dataSourceProxy.getReleasedIdleCount()).writeEnd();
        gen.writeStartObject().write("getRemoveAbandonedCount()", dataSourceProxy.getRemoveAbandonedCount()).writeEnd();
        gen.writeStartObject().write("getReturnedCount()", dataSourceProxy.getReturnedCount()).writeEnd();
        gen.writeStartObject().write("getSize()", dataSourceProxy.getSize()).writeEnd();
        gen.writeStartObject().write("getWaitCount()", dataSourceProxy.getWaitCount()).writeEnd();
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

