/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.util.List;
import java.util.Objects;
import org.kawanfw.sql.util.SqlEventUtil;

public class SqlEvent {
    private String username;
    private String database;
    private String ipAddress;
    private String sql;
    private boolean isPreparedStatement;
    private List<Object> parameterValues;
    private boolean isMetadataQuery;

    SqlEvent(String username, String database, String ipAddress, String sql, boolean isPreparedStatement, List<Object> parameterValues, boolean isMetadataQuery) {
        this.username = Objects.requireNonNull(username, "username cannnot be null!");
        this.database = Objects.requireNonNull(database, "database cannnot be null!");
        this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress cannnot be null!");
        this.sql = Objects.requireNonNull(sql, "sql cannnot be null!");
        this.isPreparedStatement = isPreparedStatement;
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues cannnot be null!");
        this.isMetadataQuery = isMetadataQuery;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    public List<String> getParameterStringValues() {
        return SqlEventUtil.toString(this.parameterValues);
    }

    public boolean isMetadataQuery() {
        return this.isMetadataQuery;
    }

    public String toString() {
        return "ClientEvent [username=" + this.username + ", database=" + this.database + ", ipAddress=" + this.ipAddress + ", sql=" + this.sql + ", isPreparedStatement=" + this.isPreparedStatement + ", parameterValues=" + SqlEventUtil.toString(this.parameterValues) + ", isMetadataQuery=" + this.isMetadataQuery + "]";
    }
}

