/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.util.JsqlParserWrapper;
import org.kawanfw.sql.api.util.StatementAnalyzerUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.Tag;

public class StatementAnalyzer {
    private static boolean DEBUG = FrameworkDebug.isSet(StatementAnalyzer.class);
    private static final String BLANK = " ";
    private String statementName;
    private final String sql;
    private List<Object> parameterValues = null;
    private List<String> tables = new ArrayList<String>();
    private boolean isDCL = false;
    private boolean isDDL = false;
    private boolean isDML = false;
    private boolean isTCL = false;
    private Statement parsedStatement = null;
    private boolean statementTypeNotParsed = false;
    private SQLException parseException;

    public StatementAnalyzer(String sql, List<Object> parameterValues) throws SQLException {
        if (sql == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "sql can not be null!");
        }
        if (parameterValues == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "parameterValues can not be null!");
        }
        this.sql = StatementAnalyzer.trimAndremoveTrailingSemicolons(sql);
        this.tables = new ArrayList<String>();
        String theStatementName = StringUtils.substringBefore((String)this.sql, (String)BLANK);
        if (theStatementName.equalsIgnoreCase("GRANT")) {
            this.statementName = "GRANT";
            this.isDCL = true;
            this.tables = new ArrayList<String>();
        } else if (theStatementName.equalsIgnoreCase("REVOKE")) {
            this.statementName = "REVOKE";
            this.isDCL = true;
            this.tables = new ArrayList<String>();
        } else if (theStatementName.equalsIgnoreCase("ROLLBACK")) {
            this.statementName = "ROLLBACK";
            this.isTCL = true;
            this.tables = new ArrayList<String>();
        } else if (theStatementName.equalsIgnoreCase("DROP")) {
            this.statementName = "DROP";
            this.isDDL = true;
            this.tables = new ArrayList<String>();
        } else {
            this.parsedStatement = null;
            try {
                this.parsedStatement = CCJSqlParserUtil.parse((String)this.sql);
                JsqlParserWrapper jsqlParserWrapper = new JsqlParserWrapper(this.parsedStatement);
                this.isDCL = jsqlParserWrapper.isDCL();
                this.isDDL = jsqlParserWrapper.isDDL();
                this.isDML = jsqlParserWrapper.isDML();
                this.isTCL = jsqlParserWrapper.isTCL();
                this.tables = jsqlParserWrapper.getTables();
                this.statementName = jsqlParserWrapper.getStatementName();
            }
            catch (JSQLParserException e) {
                if (DEBUG) {
                    e.printStackTrace(System.err);
                }
                this.parseException = new SQLException(e);
            }
        }
        if (this.parsedStatement == null) {
            this.statementTypeNotParsed = true;
        }
        if (this.statementName == null) {
            this.statementName = StringUtils.substringBefore((String)this.sql, (String)BLANK);
        }
        this.parameterValues = parameterValues;
    }

    public Statement getParsedStatement() {
        return this.parsedStatement;
    }

    public boolean isWithSemicolons() {
        String localSql = this.sql;
        localSql = StatementAnalyzer.trimAndremoveTrailingSemicolons(localSql);
        return localSql.contains(";");
    }

    private static String trimAndremoveTrailingSemicolons(String sql) {
        String sqlNew = sql.trim();
        while (sqlNew.endsWith(";")) {
            sqlNew = StringUtils.removeEnd((String)sqlNew, (String)";");
            sqlNew = sqlNew.trim();
        }
        sqlNew = StatementAnalyzerUtil.fixForJsqlparser(sqlNew);
        return sqlNew;
    }

    public boolean isWithComments() {
        return this.sql.contains("/*") && this.sql.contains("*/") || this.sql.contains("({") && this.sql.contains("})") || this.sql.contains(" --");
    }

    public String getStatementName() {
        return this.statementName;
    }

    private boolean isStatementType(String statementTypeToMatch) {
        if (statementTypeToMatch == null) {
            throw new IllegalArgumentException("statementTypeToMatch can not be null!");
        }
        if (this.statementName == null) {
            return false;
        }
        return this.statementName.equalsIgnoreCase(statementTypeToMatch);
    }

    public boolean isDelete() {
        return this.isStatementType("DELETE");
    }

    public boolean isInsert() {
        return this.isStatementType("INSERT");
    }

    public boolean isSelect() {
        return this.isStatementType("SELECT");
    }

    public boolean isUpdate() {
        return this.isStatementType("UPDATE");
    }

    public int getParameterCount() {
        return this.parameterValues.size();
    }

    public Object getLastParameter() {
        int size = this.parameterValues.size();
        if (size == 0) {
            throw new IndexOutOfBoundsException("There is no parameter.");
        }
        return this.parameterValues.get(size - 1);
    }

    public Object getFirstParameter() {
        int size = this.parameterValues.size();
        if (size == 0) {
            throw new IndexOutOfBoundsException("There is no parameter.");
        }
        return this.parameterValues.get(0);
    }

    public Object getParameter(int index) {
        int size = this.parameterValues.size();
        if (size == 0) {
            throw new IndexOutOfBoundsException("There is no parameter.");
        }
        try {
            return this.parameterValues.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Parameter index is out of bounds: " + index + ". Number of parameters: " + size);
        }
    }

    public boolean isDml() {
        return this.isDML;
    }

    public boolean isDcl() {
        return this.isDCL;
    }

    public boolean isDdl() {
        return this.isDDL;
    }

    public boolean isTcl() {
        return this.isTCL;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public boolean isStatementTypeNotParsed() {
        return this.statementTypeNotParsed;
    }

    public SQLException getParseException() {
        return this.parseException;
    }

    public String getSql() {
        return this.sql;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + BLANK + s);
        }
    }
}

