/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kawanfw.sql.api.server.BasicSqlInjectionAnalyser;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.parser.SqlCommentsDetector;
import org.kawanfw.sql.util.parser.SqlStringTokenizer;

public class StatementNormalizer {
    private static boolean DEBUG = FrameworkDebug.isSet(StatementNormalizer.class);
    private String sql;
    private boolean success;
    private boolean withNestedComments;
    private boolean withOddQuotesNumber;
    private Exception exception;

    public StatementNormalizer(String sql) {
        this.sql = sql;
    }

    public String getNormalized() {
        String sqlOut = this.sql;
        try {
            sqlOut = this.getNormalizedWithLevel(this.sql, true);
        }
        catch (Exception exception) {
            this.success = false;
            this.exception = exception;
            return this.sql;
        }
        this.success = true;
        return sqlOut;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isWithNestedComments() {
        return this.withNestedComments;
    }

    public boolean isWithOddQuotesNumber() {
        return this.withOddQuotesNumber;
    }

    public Exception getException() {
        return this.exception;
    }

    private String getNormalizedWithLevel(String sql, boolean strongNormalizationLevel) throws SQLException {
        Objects.requireNonNull(sql, "sql cannot be null!");
        this.success = false;
        this.withNestedComments = BasicSqlInjectionAnalyser.containsNestedComments(sql);
        if (this.withNestedComments) {
            throw new SQLException("Input SQL contains not supported nested comments.");
        }
        SqlCommentsDetector sqlCommentsDetector = new SqlCommentsDetector(sql);
        int singleQuoteQuantity = StringUtils.countMatches((CharSequence)(sql = sqlCommentsDetector.removeComments()), (CharSequence)"'");
        if (singleQuoteQuantity % 2 != 0) {
            this.withOddQuotesNumber = true;
            throw new SQLException("Input SQL contains an invalid odd number of single quotes.");
        }
        List<String> tokens = SqlStringTokenizer.getTokensSplitOnSinglesQuotes(sql);
        StringBuffer sb = new StringBuffer();
        StatementNormalizer.debug("display 2:");
        int i = 0;
        while (i < tokens.size()) {
            StatementNormalizer.debug(String.valueOf(i) + ": " + tokens.get(i));
            if (i % 2 == 0) {
                sb.append(StatementNormalizer.getNormalizedSubtring(tokens.get(i)));
            } else if (strongNormalizationLevel) {
                sb.append(" ? ");
            } else {
                sb.append("'" + tokens.get(i) + "'");
            }
            ++i;
        }
        String normalized = sb.toString();
        normalized = strongNormalizationLevel ? StatementNormalizer.replaceNumericValuesPerQuestionMark(normalized) : normalized.replace("__kawan_single_quote__", "''");
        return normalized;
    }

    private static String replaceNumericValuesPerQuestionMark(String normalized) {
        StringTokenizer stringTokenizer = new StringTokenizer(normalized, " ()", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            String token = stringTokenizer.nextToken();
            if (NumberUtils.isParsable((String)token)) {
                stringBuffer.append("?");
                continue;
            }
            stringBuffer.append(token);
        }
        return stringBuffer.toString().trim();
    }

    private static String getNormalizedSubtring(String substring) {
        Objects.requireNonNull(substring, "substring cannot be null");
        if (substring.contains("'")) {
            throw new IllegalArgumentException("substring to normalize cannot contains quotes (').");
        }
        if (substring.contains("\"")) {
            throw new IllegalArgumentException("A Statement to normalize cannot contain double-quotes outside of a string enclosed in single quotes: " + substring);
        }
        if (substring.contains(";")) {
            throw new IllegalArgumentException("A Statement to normalize cannot contain semicolons outside of a string enclosed in single quotes: " + substring);
        }
        if (substring.contains("#")) {
            throw new IllegalArgumentException("A Statement to normalize cannot contain hashtags outside of a string enclosed in single quotes: " + substring);
        }
        List<String> tokens = SqlStringTokenizer.getTokensSplitOnSpace(substring);
        String normalizedString = SqlStringTokenizer.tokensTrimAndConcatenate(tokens);
        return normalizedString;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

