/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.util.auth.ConfigurablePasswordEncryptorUtil;
import org.kawanfw.sql.api.util.auth.PasswordEncryptorUtil;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.version.VersionWrapper;

public class JdbcPasswordEncryptor {
    private ConfigurablePasswordEncryptor passwordEncryptor;

    public JdbcPasswordEncryptor(File propertiesFile) throws DatabaseConfigurationException, IOException {
        Objects.requireNonNull(propertiesFile, "propertiesFile cannot be null!");
        if (!propertiesFile.exists()) {
            throw new FileNotFoundException("The properties file does not exist: " + propertiesFile);
        }
        PropertiesFileStore.set(propertiesFile);
        Properties properties = PropertiesFileUtil.getProperties(propertiesFile);
        this.passwordEncryptor = ConfigurablePasswordEncryptorUtil.getConfigurablePasswordEncryptor(properties);
    }

    public String encryptPassword(String password) {
        Objects.requireNonNull(password, "password cannot be null!");
        String encryptedPassword = this.passwordEncryptor.encryptPassword(password);
        return encryptedPassword.trim().toLowerCase();
    }

    public static void main(String[] args) throws ParseException, DatabaseConfigurationException, IOException {
        CommandLine cmd = null;
        Options options = null;
        try {
            options = PasswordEncryptorUtil.createOptions();
            DefaultParser parser = new DefaultParser();
            cmd = parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            System.out.println();
            PasswordEncryptorUtil.printUsage(options);
            System.exit(1);
        }
        if (cmd.hasOption("help")) {
            PasswordEncryptorUtil.printUsage(options);
            System.exit(1);
        }
        if (cmd.hasOption("version")) {
            System.out.println(VersionWrapper.getServerVersion());
            System.out.println();
            System.exit(1);
        }
        String fileStr = null;
        if (cmd.hasOption("properties")) {
            fileStr = cmd.getOptionValue("properties");
        } else {
            System.out.println("Missing properties option.");
            PasswordEncryptorUtil.printUsage(options);
            System.exit(1);
        }
        String password = null;
        if (cmd.hasOption("password")) {
            password = cmd.getOptionValue("password");
        } else {
            System.out.println("Missing password option.");
            PasswordEncryptorUtil.printUsage(options);
            System.exit(1);
        }
        File file = new File(fileStr);
        JdbcPasswordEncryptor jdbcPasswordEncryptor = new JdbcPasswordEncryptor(file);
        String passwordEncrypted = jdbcPasswordEncryptor.encryptPassword(password);
        System.out.println(passwordEncrypted);
    }
}

