/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.api.util.auth.ConfigurablePasswordEncryptorUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClasses;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;

public class JdbcUserAuthenticator
implements UserAuthenticator {
    private Properties properties = null;
    private ConfigurablePasswordEncryptor passwordEncryptor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login(String username, char[] password, String database, String ipAddress) throws IOException, SQLException {
        String authenticationDatabase;
        String authenticationQuery;
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        if ((authenticationQuery = this.properties.getProperty("jdbcUserAuthenticator.authenticationQuery")) == null || authenticationQuery.isEmpty()) {
            authenticationQuery = "SELECT encrypted_password FROM users WHERE username = ?";
        }
        if ((authenticationDatabase = this.properties.getProperty("jdbcUserAuthenticator.database")) == null || authenticationDatabase.isEmpty()) {
            authenticationDatabase = JdbcUserAuthenticator.getFirtDatabase();
        }
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(authenticationDatabase);
        Throwable throwable = null;
        Object var9_10 = null;
        try (Connection connection = databaseConfigurator.getConnection(database);){
            if (this.passwordEncryptor == null) {
                this.passwordEncryptor = ConfigurablePasswordEncryptorUtil.getConfigurablePasswordEncryptor(this.properties);
            }
            try {
                String encryptedPassword = JdbcUserAuthenticator.getEncryptedPassword(authenticationQuery, username, connection);
                if (encryptedPassword != null) return this.passwordEncryptor.checkPassword(new String(password), encryptedPassword.toLowerCase());
                return false;
            }
            catch (SQLException exception) {
                throw new SQLException("[USER CONFIGURATION] The dbcUserAuthenticator.authenticationQuery triggers an SQLException: " + exception);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static String getEncryptedPassword(String authenticationQuery, String username, Connection connection) throws SQLException {
        Objects.requireNonNull(authenticationQuery, "authenticationQuery cannot be null!");
        Objects.requireNonNull(username, "username cannot be null!");
        Objects.requireNonNull(connection, "connection cannot be null!");
        PreparedStatement prepStatement = connection.prepareStatement(authenticationQuery);
        prepStatement.setString(1, username);
        ResultSet rs = prepStatement.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    private static String getFirtDatabase() {
        InjectedClasses injectedClasses = InjectedClassesStore.get();
        Map<String, DatabaseConfigurator> map = injectedClasses.getDatabaseConfigurators();
        Set<String> databases = map.keySet();
        String database = databases.iterator().next();
        return database;
    }
}

