/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class LdapUserAuthenticator
implements UserAuthenticator {
    private Logger logger = null;
    private Properties properties = null;

    @Override
    public boolean login(String username, char[] password, String database, String ipAddress) throws IOException, SQLException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        String url = this.properties.getProperty("ldapUserAuthenticator.url");
        Objects.requireNonNull(url, String.valueOf(this.getInitTag()) + "The ldapUserAuthenticator.url property cannot be null!");
        String securityAuth = this.properties.getProperty("ldapUserAuthenticator.securityAuthentication");
        String securityProtocol = this.properties.getProperty("ldapUserAuthenticator.securityProtocol");
        Hashtable<String, String> env = this.buildHashtable(username, password, url, securityAuth, securityProtocol);
        InitialDirContext ctx = null;
        if (this.logger == null) {
            DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
            this.logger = databaseConfigurator.getLogger();
        }
        try {
            try {
                ctx = new InitialDirContext(env);
            }
            catch (CommunicationException e) {
                throw new IOException(String.valueOf(this.getInitTag()) + "Impossible to connect to server: " + url);
            }
            catch (NamingException e) {
                LoggerWrapper.logError(this.logger, String.valueOf(this.getInitTag()) + LdapUserAuthenticator.class.getName() + " Unable to authenticate user: " + username);
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        LoggerWrapper.log(this.logger, String.valueOf(this.getInitTag()) + LdapUserAuthenticator.class.getName() + " InitialDirContext.close() Exception: ", e2);
                    }
                }
                return false;
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    LoggerWrapper.log(this.logger, String.valueOf(this.getInitTag()) + LdapUserAuthenticator.class.getName() + " InitialDirContext.close() Exception: ", e);
                }
            }
        }
        return true;
    }

    private Hashtable<String, String> buildHashtable(String username, char[] password, String url, String securityAuth, String securityProtocol) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        if (securityAuth != null && !securityAuth.isEmpty()) {
            env.put("java.naming.security.authentication", securityAuth);
        }
        if (securityProtocol != null && !securityProtocol.isEmpty()) {
            env.put("java.naming.security.protocol", securityProtocol);
        }
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", new String(password));
        return env;
    }

    private String getInitTag() {
        return String.valueOf(Tag.PRODUCT) + " " + LdapUserAuthenticator.class.getSimpleName() + ": ";
    }
}

