/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class SshUserAuthenticator
implements UserAuthenticator {
    private Logger logger = null;
    private Properties properties = null;

    @Override
    public boolean login(String username, char[] password, String database, String ipAddress) throws IOException, SQLException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        String host = this.properties.getProperty("sshUserAuthenticator.host");
        String portStr = this.properties.getProperty("sshUserAuthenticator.port");
        Objects.requireNonNull(host, String.valueOf(this.getInitTag()) + "The sshUserAuthenticator.host property is null!");
        if (portStr == null) {
            portStr = "22";
        }
        if (!StringUtils.isNumeric((CharSequence)portStr)) {
            throw new IllegalArgumentException(String.valueOf(this.getInitTag()) + "The sshUserAuthenticator.port property is not numeric: " + portStr);
        }
        int port = Integer.parseInt(portStr);
        JSch jsch = new JSch();
        Session session = null;
        try {
            session = jsch.getSession(username, host, port);
        }
        catch (JSchException e) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
                this.logger = databaseConfigurator.getLogger();
            }
            this.logger.error(String.valueOf(this.getInitTag()) + "username: " + username + " or host:" + host + " is invalid.");
        }
        session.setPassword(new String(password));
        session.setConfig("StrictHostKeyChecking", "no");
        boolean connected = false;
        try {
            session.connect();
            connected = true;
            session.disconnect();
        }
        catch (JSchException e) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
                this.logger = databaseConfigurator.getLogger();
            }
            LoggerWrapper.log(this.logger, String.valueOf(this.getInitTag()) + "SSH connection impossible for " + username + "@" + host + ":" + port + ".", e);
        }
        return connected;
    }

    private String getInitTag() {
        return String.valueOf(Tag.PRODUCT) + " " + SshUserAuthenticator.class.getSimpleName() + ": ";
    }
}

