/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.api.server.util.SimpleHttpClient;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class WebServiceUserAuthenticator
implements UserAuthenticator {
    private Properties properties = null;
    private String database = null;
    private Logger logger = null;

    @Override
    public boolean login(String username, char[] password, String database, String ipAddress) throws IOException, SQLException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        this.database = Objects.requireNonNull(database, "database cannot be null!");
        String url = this.properties.getProperty("webServiceUserAuthenticator.url");
        String timeoutSecondsStr = this.properties.getProperty("webServiceUserAuthenticator.timeoutSeconds");
        String httpTraceStr = this.properties.getProperty("webServiceUserAuthenticator.httpTrace");
        if (url == null || url.contentEquals("localhost")) {
            return true;
        }
        if (timeoutSecondsStr == null) {
            timeoutSecondsStr = "0";
        }
        if (!StringUtils.isNumeric((CharSequence)timeoutSecondsStr)) {
            throw new IllegalArgumentException("The default.login.webService.timeoutSeconds property is not numeric: " + timeoutSecondsStr);
        }
        int timeoutSeconds = Integer.parseInt(timeoutSecondsStr);
        int connectTimeout = timeoutSeconds * 1000;
        int readTimeout = timeoutSeconds * 1000;
        this.setTraceActivity(httpTraceStr);
        Map<String, String> parametersMap = this.buildParametersMap(username, password);
        String jsonResult = this.buildJsonResult(username, url, connectTimeout, readTimeout, parametersMap);
        if (jsonResult == null) {
            return false;
        }
        return this.statusIsOk(jsonResult.trim());
    }

    private void setTraceActivity(String httpTraceStr) {
        SimpleHttpClient.TRACE_ON = Boolean.parseBoolean(httpTraceStr);
    }

    private boolean statusIsOk(String jsonResult) throws IOException {
        try {
            JsonReader reader = Json.createReader((Reader)new StringReader(jsonResult));
            JsonStructure jsonst = reader.read();
            JsonObject object = (JsonObject)jsonst;
            JsonString status = (JsonString)object.get((Object)"status");
            return status != null && status.getString().equals("OK");
        }
        catch (Exception e) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
                this.logger = databaseConfigurator.getLogger();
            }
            this.logger.error(String.valueOf(this.getInitTag()) + "Error when parsing jsonResult of Authentication Web Service: " + e.getMessage());
            return false;
        }
    }

    private String buildJsonResult(String username, String url, int connectTimeout, int readTimeout, Map<String, String> parametersMap) throws IOException {
        SimpleHttpClient simpleHttpClient = new SimpleHttpClient(connectTimeout, readTimeout);
        String jsonResult = null;
        try {
            jsonResult = simpleHttpClient.callWithPost(new URL(url), parametersMap);
        }
        catch (Exception e) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
                this.logger = databaseConfigurator.getLogger();
            }
            this.logger.error(String.valueOf(this.getInitTag()) + "Username " + username + " can not authenticate. Error when calling SimpleHttpClient: " + e.getMessage());
            return null;
        }
        return jsonResult;
    }

    private Map<String, String> buildParametersMap(String username, char[] password) {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put("username", username);
        parametersMap.put("password", new String(password));
        return parametersMap;
    }

    private String getInitTag() {
        return String.valueOf(Tag.PRODUCT) + " " + WebServiceUserAuthenticator.class.getSimpleName() + ": ";
    }
}

