/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth;

import com.sun.jna.platform.win32.Win32Exception;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.auth.UserAuthenticator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WindowsUserAuthenticator
implements UserAuthenticator {
    private Logger logger = null;
    private Properties properties = null;

    @Override
    public boolean login(String username, char[] password, String database, String ipAddress) throws IOException, SQLException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        String domain = this.properties.getProperty("windowsUserAuthenticator.domain");
        try {
            WindowsAuthProviderImpl windowsAuthProviderImpl = new WindowsAuthProviderImpl();
            windowsAuthProviderImpl.logonDomainUser(username, domain, new String(password));
            return true;
        }
        catch (Win32Exception Wwn32Exception) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
                this.logger = databaseConfigurator.getLogger();
            }
            LoggerWrapper.logError(this.logger, String.valueOf(this.getInitTag()) + "WindowsLogin.login refused for " + username);
            return false;
        }
        catch (Exception exception) {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
                this.logger = databaseConfigurator.getLogger();
            }
            LoggerWrapper.log(this.logger, String.valueOf(this.getInitTag()) + "AceQL WindowsLogin.login call failure (Waffle Library): ", exception);
            return false;
        }
    }

    private String getInitTag() {
        return String.valueOf(Tag.PRODUCT) + " " + WindowsUserAuthenticator.class.getSimpleName() + ": ";
    }
}

