/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.kawanfw.sql.api.server.auth.crypto.PropertiesPasswordManager;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.util.FrameworkDebug;

public class DefaultPropertiesPasswordManager
implements PropertiesPasswordManager {
    private static boolean DEBUG = FrameworkDebug.isSet(DefaultPropertiesPasswordManager.class);

    @Override
    public char[] getPassword() throws IOException, SQLException {
        File dir = PropertiesFileStore.get().getParentFile();
        File file = new File(dir + File.separator + "properties_password_manager.properties");
        DefaultPropertiesPasswordManager.debug("Dir of aceql-server.properties                :" + dir);
        DefaultPropertiesPasswordManager.debug("File of properties_password_manager.properties:" + file);
        if (!file.exists()) {
            DefaultPropertiesPasswordManager.debug(String.valueOf(file.toString()) + " does not exist. No decryption todo.");
            return null;
        }
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String password = properties.getProperty("password");
        DefaultPropertiesPasswordManager.debug("password: " + password);
        if (password == null || password.isEmpty()) {
            throw new IOException("[USER CONFIGURATION] password property not defined in file: " + file);
        }
        return password.toCharArray();
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + DefaultPropertiesPasswordManager.class.getSimpleName() + " " + s);
        }
    }
}

