/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.auth.crypto;

import java.io.Console;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.kawanfw.sql.api.server.auth.crypto.PropertiesEncryptorWrap;

public class PropertiesEncryptor {
    public static final String VERSION = "1.0";

    public static void main(String[] args) throws Exception {
        PropertiesEncryptor.doIt();
    }

    public static void doIt() {
        System.out.println();
        System.out.println("Welcome to AceQL Properties Encryptor 1.0!");
        System.out.println("Enter \"quit\" to exit at any time.");
        System.out.println();
        System.out.println("First step is to choose a password that will be used to encrypt properties.");
        System.out.println("(This password will be returned by the PropertiesPasswordManager.getPassword() implementation.)");
        System.out.println();
        String password = PropertiesEncryptor.createPassword();
        if (password == null) {
            return;
        }
        System.out.println();
        System.out.println("Password created! ");
        System.out.println();
        System.out.println("Second step is to encrypt desired property values:");
        System.out.println(" - Replace each clear value with the encrypted one in the aceql-properties file.");
        System.out.println(" - Encrypted values include the \"ENC(\" prefix and \")\" trailer.");
        System.out.println();
        StandardPBEStringEncryptor encryptor = PropertiesEncryptorWrap.createEncryptor(password);
        Console console = System.console();
        while (true) {
            String valueToEncrypt;
            if ((valueToEncrypt = console.readLine("Value to encrypt: ", new Object[0])) == null || valueToEncrypt.isEmpty()) {
                continue;
            }
            if (valueToEncrypt.equals("quit")) break;
            String encryptedValue = encryptor.encrypt(valueToEncrypt);
            System.out.println("Encrypted value : ENC(" + encryptedValue + ")");
            System.out.println();
        }
    }

    private static String createPassword() {
        Console console = System.console();
        while (true) {
            char[] passwordChars;
            if ((passwordChars = console.readPassword("Enter Password: ", new Object[0])) == null || passwordChars.length == 0) {
                continue;
            }
            String password1 = new String(passwordChars);
            if (password1.equals("quit")) {
                return null;
            }
            if (password1.length() < 8) {
                System.out.println("Password is too short. Must be 8 characters minimium. Please retry.");
                System.out.println();
                continue;
            }
            String password2 = new String(console.readPassword("Verify Password: ", new Object[0]));
            if (password1 == null || password1.isEmpty() || password2 == null || password2.isEmpty()) {
                System.out.println("Please enter a value! (or \"quit\" to exit)");
                continue;
            }
            if (password1.equals(password2)) {
                return password1;
            }
            System.out.println("Password values do not match! Please retry or enter \"quit\" to exit");
            System.out.println();
        }
    }
}

