/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.fileupload.util.Streams;
import org.kawanfw.sql.api.server.blob.BlobUploadConfigurator;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.FrameworkFileUtil;

public class DefaultBlobUploadConfigurator
implements BlobUploadConfigurator {
    private static boolean DEBUG = FrameworkDebug.isSet(DefaultBlobUploadConfigurator.class);

    @Override
    public void upload(HttpServletRequest request, HttpServletResponse response, File blobDirectory, long maxBlobLength) throws IOException, FileUploadException {
        this.debug("in upload()");
        response.setContentType("text/html");
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        this.debug("isMultipart: " + isMultipart);
        if (!isMultipart) {
            return;
        }
        File tempRepository = new File(SystemUtils.getUserHome() + File.separator + "tmp");
        tempRepository.mkdirs();
        this.debug("tempRepository: " + tempRepository);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(tempRepository);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        this.debug("maxBlobLength: " + maxBlobLength);
        if (DEBUG) {
            String tempDir = FrameworkFileUtil.getUserHomeDotKawansoftDir();
            FileUtils.write((File)new File(String.valueOf(tempDir) + File.separator + "maxBlobLength.txt"), (CharSequence)String.valueOf(maxBlobLength), (Charset)StandardCharsets.UTF_8);
        }
        if (maxBlobLength > 0L) {
            upload.setFileSizeMax(maxBlobLength);
        } else {
            upload.setFileSizeMax(Long.MAX_VALUE);
        }
        FileItemIterator iter = upload.getItemIterator(request);
        String blobId = null;
        while (iter.hasNext()) {
            FileItemStream item = iter.next();
            String name = item.getFieldName();
            this.debug("name: " + name);
            Throwable throwable = null;
            Object var15_15 = null;
            try (InputStream inputstream = item.openStream();){
                if (item.isFormField()) {
                    if (!name.equals("blob_id")) continue;
                    blobId = Streams.asString((InputStream)inputstream);
                    this.debug("blob_id: " + blobId);
                    continue;
                }
                this.debug("");
                this.debug("File field " + name + " with file name " + item.getName() + " detected.");
                this.debug("blobId: " + blobId);
                Path path = Paths.get(blobId, new String[0]);
                String fileName = String.valueOf(blobDirectory.toString()) + File.separator + blobId;
                Files.copy(inputstream, new File(fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

