/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.connectionstore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.connectionstore.ConnectionKey;
import org.kawanfw.sql.servlet.connection.ConnectionStore;

public class ConnectionStoreManager {
    protected ConnectionStoreManager() {
    }

    public static Set<ConnectionKey> getKeys() {
        return ConnectionStore.getKeys();
    }

    public static void remove(ConnectionKey connectionKey, DatabaseConfigurator databaseConfigurator) throws SQLException {
        if (connectionKey == null) {
            throw new IllegalArgumentException("connectionKey is null!");
        }
        if (databaseConfigurator == null) {
            throw new IllegalArgumentException("databaseConfigurator is null!");
        }
        ConnectionStore connectionStore = new ConnectionStore(connectionKey.getUsername(), connectionKey.getSessionId(), connectionKey.getConnectionId());
        Connection connection = connectionStore.get();
        connectionStore.remove();
        databaseConfigurator.close(connection);
    }

    public static int size() {
        return ConnectionStore.getKeys().size();
    }
}

