/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.executor;

import java.util.List;
import java.util.Objects;
import org.kawanfw.sql.util.SqlEventUtil;

public class ClientEvent {
    private String username;
    private String database;
    private String ipAddress;
    private List<Object> parameterValues;

    ClientEvent(String username, String database, String ipAddress, List<Object> parameterValues) {
        this.username = Objects.requireNonNull(username, "username cannnot be null!");
        this.database = Objects.requireNonNull(database, "database cannnot be null!");
        this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress cannnot be null!");
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues cannnot be null!");
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    public List<String> getParameterStringValues() {
        return SqlEventUtil.toString(this.parameterValues);
    }

    public String toString() {
        return "ClientEvent [username=" + this.username + ", database=" + this.database + ", ipAddress=" + this.ipAddress + ", parameterValues=" + SqlEventUtil.toString(this.parameterValues) + "]";
    }
}

