/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.firewall;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.StatementAnalyzer;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.CsvRulesManagerLoader;
import org.kawanfw.sql.api.util.firewall.DatabaseUserTableTriplet;
import org.kawanfw.sql.api.util.firewall.TableAllowStatements;
import org.kawanfw.sql.metadata.AceQLMetaData;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.TimestampUtil;
import org.slf4j.Logger;

public class CsvRulesManager
implements SqlFirewallManager {
    private static boolean DEBUG = FrameworkDebug.isSet(CsvRulesManager.class);
    private Set<String> databaseSetForReset = new HashSet<String>();
    private Map<DatabaseUserTableTriplet, TableAllowStatements> mapTableAllowStatementsSet = null;
    private FileTime storedFileTime = null;
    protected boolean allowReload = true;

    @Override
    public boolean allowSqlRunAfterAnalysis(SqlEvent sqlEvent, Connection connection) throws IOException, SQLException {
        this.loadRules(sqlEvent.getDatabase(), connection);
        boolean isAllowed = this.isAllowed(sqlEvent.getUsername(), sqlEvent.getDatabase(), sqlEvent.getSql(), sqlEvent.getParameterValues());
        return isAllowed;
    }

    @Override
    public boolean allowStatementClass(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }

    @Override
    public boolean allowMetadataQuery(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }

    private boolean isAllowed(String username, String database, String sql, List<Object> parameterValues) throws SQLException {
        StatementAnalyzer analyzer = new StatementAnalyzer(sql, parameterValues);
        List<String> tables = analyzer.getTables();
        String statementName = analyzer.getStatementName();
        statementName = statementName.toLowerCase();
        this.debug("");
        this.debug("Testing statement: " + statementName + ":");
        boolean isAllowed = false;
        for (String table : tables) {
            table = table.toLowerCase();
            DatabaseUserTableTriplet databaseUserTableTriplet = new DatabaseUserTableTriplet(database, "public", "all");
            TableAllowStatements tableAllowStatements = this.mapTableAllowStatementsSet.get(databaseUserTableTriplet);
            this.debug("public and all -  tableAllowStatements: " + tableAllowStatements + ":");
            if (tableAllowStatements != null && (isAllowed = this.isAllowed(tableAllowStatements, statementName))) {
                return true;
            }
            databaseUserTableTriplet = new DatabaseUserTableTriplet(database, "public", table);
            tableAllowStatements = this.mapTableAllowStatementsSet.get(databaseUserTableTriplet);
            this.debug("public -  tableAllowStatements: " + tableAllowStatements + ":");
            if (tableAllowStatements != null && (isAllowed = this.isAllowed(tableAllowStatements, statementName))) {
                return true;
            }
            databaseUserTableTriplet = new DatabaseUserTableTriplet(database, username, "all");
            tableAllowStatements = this.mapTableAllowStatementsSet.get(databaseUserTableTriplet);
            this.debug("all -  tableAllowStatements: " + tableAllowStatements + ":");
            if (tableAllowStatements != null && (isAllowed = this.isAllowed(tableAllowStatements, statementName))) {
                return true;
            }
            databaseUserTableTriplet = new DatabaseUserTableTriplet(database, username, table);
            tableAllowStatements = this.mapTableAllowStatementsSet.get(databaseUserTableTriplet);
            this.debug("tableAllowStatements: " + tableAllowStatements + ":");
            if (tableAllowStatements == null || !(isAllowed = this.isAllowed(tableAllowStatements, statementName))) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowed(TableAllowStatements tableAllowStatements, String statementName) {
        if (statementName.equals("delete")) {
            return tableAllowStatements.isDeleteAllowed();
        }
        if (statementName.equals("insert")) {
            return tableAllowStatements.isInsertAllowe();
        }
        if (statementName.equals("select")) {
            return tableAllowStatements.isSelectAllowed();
        }
        if (statementName.equals("update")) {
            return tableAllowStatements.isUpdateAllowed();
        }
        return false;
    }

    private void loadRules(String database, Connection connection) throws FileNotFoundException, SQLException, IOException {
        File csvFile = CsvRulesManager.getCsvFile(database);
        BasicFileAttributes basicFileAttributes = Files.readAttributes(csvFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        FileTime currentFileTime = basicFileAttributes.lastModifiedTime();
        this.debug("");
        this.debug("csvFile        : " + csvFile);
        this.debug("allowReload    : " + this.allowReload);
        this.debug("storedFileTime : " + this.storedFileTime);
        this.debug("currentFileTime: " + currentFileTime);
        if (this.storedFileTime != null && !currentFileTime.equals(this.storedFileTime) && this.allowReload) {
            this.mapTableAllowStatementsSet = null;
            this.databaseSetForReset = new HashSet<String>();
            String logInfo = String.valueOf(TimestampUtil.getHumanTimestampNow()) + " " + "[USER CONFIGURATION]" + " Reloading CsvRulesManager configuration file: " + csvFile;
            System.err.println(logInfo);
            DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
            Logger logger = databaseConfigurator.getLogger();
            LoggerWrapper.log(logger, logInfo);
            this.storedFileTime = currentFileTime;
        }
        if (this.mapTableAllowStatementsSet == null || !this.databaseSetForReset.contains(database)) {
            AceQLMetaData aceQLMetaData = new AceQLMetaData(connection);
            List<String> tables = aceQLMetaData.getTableNames();
            TreeSet<String> tableSet = new TreeSet<String>();
            for (String table : tables) {
                tableSet.add(table.toLowerCase());
            }
            tableSet.add("all");
            CsvRulesManagerLoader csvRulesManagerLoader = new CsvRulesManagerLoader(csvFile, database, tableSet);
            csvRulesManagerLoader.load();
            this.mapTableAllowStatementsSet = csvRulesManagerLoader.getMapTableAllowStatementsSet();
            this.databaseSetForReset.add(database);
            Set<TableAllowStatements> tableAllowStatementsSet = csvRulesManagerLoader.getTableAllowStatementsSet();
            this.debug("CsvRulesManager Rules Loaded:");
            for (TableAllowStatements tableAllowStatements : tableAllowStatementsSet) {
                this.debug(tableAllowStatements.toString());
            }
            this.storedFileTime = currentFileTime;
        }
    }

    private static File getCsvFile(String database) throws FileNotFoundException {
        File file = PropertiesFileStore.get();
        Objects.requireNonNull(file, "file cannot be null!");
        if (!file.exists()) {
            throw new FileNotFoundException("The properties file does not exist: " + file);
        }
        File dir = PropertiesFileStore.get().getParentFile();
        File csvFile = new File(dir + File.separator + database + "_rules_manager.csv");
        if (!csvFile.exists()) {
            throw new FileNotFoundException("The CSV rules files does not exist: " + csvFile);
        }
        return csvFile;
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(new Date() + " " + CsvRulesManager.class.getSimpleName() + " " + string);
        }
    }
}

