/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.firewall;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.StatementNormalizer;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.TextStatementsListLoader;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.TimestampUtil;
import org.slf4j.Logger;

public class DenyExceptOnWhitelistManager
implements SqlFirewallManager {
    private static boolean DEBUG = FrameworkDebug.isSet(DenyExceptOnWhitelistManager.class);
    private Map<String, Set<String>> statementMap = new HashMap<String, Set<String>>();
    private FileTime storedFileTime = null;
    protected boolean allowReload = true;

    @Override
    public boolean allowSqlRunAfterAnalysis(SqlEvent sqlEvent, Connection connection) throws IOException, SQLException {
        String database = sqlEvent.getDatabase();
        String sql = sqlEvent.getSql();
        StatementNormalizer statementNormalizer = new StatementNormalizer(sql);
        sql = statementNormalizer.getNormalized();
        this.loadStatements(database, "_deny_except_whitelist.txt");
        Set<String> allowedStatementsForDb = this.statementMap.get(database);
        if (allowedStatementsForDb == null || allowedStatementsForDb.isEmpty()) {
            return false;
        }
        return allowedStatementsForDb.contains(sql);
    }

    @Override
    public boolean allowStatementClass(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }

    @Override
    public boolean allowMetadataQuery(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }

    private void loadStatements(String database, String fileSuffix) throws FileNotFoundException, SQLException, IOException {
        File textFile = DenyExceptOnWhitelistManager.getTextFile(database, fileSuffix);
        BasicFileAttributes basicFileAttributes = Files.readAttributes(textFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        FileTime currentFileTime = basicFileAttributes.lastModifiedTime();
        this.debug("");
        this.debug("textFile       : " + textFile);
        this.debug("allowReload    : " + this.allowReload);
        this.debug("storedFileTime : " + this.storedFileTime);
        this.debug("currentFileTime: " + currentFileTime);
        if (this.storedFileTime != null && !currentFileTime.equals(this.storedFileTime) && this.allowReload) {
            this.statementMap = new HashMap<String, Set<String>>();
            String logInfo = String.valueOf(TimestampUtil.getHumanTimestampNow()) + " " + "[USER CONFIGURATION]" + " Reloading " + this.getClass().getSimpleName() + " configuration file: " + textFile;
            System.err.println(logInfo);
            DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
            Logger logger = databaseConfigurator.getLogger();
            LoggerWrapper.log(logger, logInfo);
            this.storedFileTime = currentFileTime;
        }
        if (!this.statementMap.containsKey(database)) {
            if (!textFile.exists()) {
                throw new FileNotFoundException("The file that contains the statements to blacklist does not exist: " + textFile);
            }
            TextStatementsListLoader textStatementsListLoader = new TextStatementsListLoader(textFile);
            textStatementsListLoader.load();
            this.statementMap.put(database, textStatementsListLoader.getNormalizedStatementSet());
            this.storedFileTime = currentFileTime;
        }
    }

    static File getTextFile(String database, String fileSuffix) throws FileNotFoundException {
        File file = PropertiesFileStore.get();
        Objects.requireNonNull(file, "file cannot be null!");
        if (!file.exists()) {
            throw new FileNotFoundException("The properties file does not exist: " + file);
        }
        File dir = PropertiesFileStore.get().getParentFile();
        File textFile = new File(dir + File.separator + database + fileSuffix);
        if (!textFile.exists()) {
            throw new FileNotFoundException("The statements text file does not exist: " + textFile);
        }
        return textFile;
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(new Date() + " " + this.getClass().getSimpleName() + " " + string);
        }
    }
}

