/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.firewall;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.cloudmersive.CloudmersiveApi;
import org.kawanfw.sql.api.util.firewall.cloudmersive.DenySqlInjectionManagerUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.Tag;
import org.slf4j.Logger;

public class DenySqlInjectionManager
implements SqlFirewallManager {
    private CloudmersiveApi cloudmersiveApi = null;
    private Logger logger;

    @Override
    public boolean allowSqlRunAfterAnalysis(SqlEvent sqlEvent, Connection connection) throws IOException, SQLException {
        try {
            if (this.logger == null) {
                DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(sqlEvent.getDatabase());
                this.logger = databaseConfigurator.getLogger();
            }
            String sql = sqlEvent.getSql();
            if (this.cloudmersiveApi == null) {
                this.cloudmersiveApi = new CloudmersiveApi(DenySqlInjectionManagerUtil.getCloudmersivePropertiesFile());
            }
            return !this.cloudmersiveApi.sqlInjectionDetect(sql);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                LoggerWrapper.log(this.logger, String.valueOf(Tag.PRODUCT) + ": " + DenySqlInjectionManager.class.getSimpleName() + " Unable to verify SQL injection: ", exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            return true;
        }
    }

    @Override
    public boolean allowStatementClass(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }

    @Override
    public boolean allowMetadataQuery(String username, String database, Connection connection) throws IOException, SQLException {
        return true;
    }
}

