/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.firewall.trigger;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.firewall.trigger.SqlFirewallTrigger;
import org.kawanfw.sql.api.server.logging.LoggerCreator;
import org.kawanfw.sql.servlet.util.SqlFirewallTriggerUtil;
import org.kawanfw.sql.servlet.util.logging.GenericLoggerCreator;
import org.kawanfw.sql.servlet.util.logging.LoggerCreatorProperties;
import org.kawanfw.sql.servlet.util.logging.LoggerWrapper;
import org.kawanfw.sql.util.FrameworkDebug;
import org.slf4j.Logger;

public class JsonLoggerSqlFirewallTrigger
implements SqlFirewallTrigger {
    private static boolean DEBUG = FrameworkDebug.isSet(JsonLoggerSqlFirewallTrigger.class);
    private static Logger ACEQL_LOGGER = null;
    private static Map<String, String> LOGGER_ELEMENTS = new ConcurrentHashMap<String, String>();

    @Override
    public void runIfStatementRefused(SqlEvent sqlEvent, SqlFirewallManager sqlFirewallManager, Connection connection) throws IOException, SQLException {
        String jsonString = SqlFirewallTriggerUtil.toJsonString(sqlEvent, sqlFirewallManager);
        if (ACEQL_LOGGER == null) {
            LoggerCreator loggerCreator = this.getLoggerCreator();
            ACEQL_LOGGER = loggerCreator.getLogger();
            LOGGER_ELEMENTS = loggerCreator.getElements();
        }
        LoggerWrapper.log(ACEQL_LOGGER, jsonString);
    }

    public static Map<String, String> getLoggerElements() {
        return LOGGER_ELEMENTS;
    }

    private LoggerCreator getLoggerCreator() throws IOException {
        String fileNamePattern = String.valueOf(this.getClass().getSimpleName()) + "_%d.log.%i";
        LoggerCreatorProperties loggerCreatorProperties = LoggerCreatorProperties.getFileBasedProperties(this.getClass().getSimpleName());
        GenericLoggerCreator loggerCreator = null;
        if (loggerCreatorProperties != null) {
            JsonLoggerSqlFirewallTrigger.debug("loggerCreatorProperties: " + loggerCreatorProperties.toString());
            loggerCreator = GenericLoggerCreator.newBuilder().name(this.getClass().getSimpleName()).fileNamePattern(fileNamePattern).pattern(loggerCreatorProperties.getPattern()).logDirectory(loggerCreatorProperties.getLogDirectory()).maxFileSize(loggerCreatorProperties.getMaxFileSize()).totalSizeCap(loggerCreatorProperties.getTotalSizeCap()).displayOnConsole(loggerCreatorProperties.isDisplayOnConsole()).displayLogStatusMessages(loggerCreatorProperties.isDisplayLogStatusMessages()).build();
        } else {
            JsonLoggerSqlFirewallTrigger.debug("loggerCreatorProperties is null!");
            loggerCreator = GenericLoggerCreator.newBuilder().name(this.getClass().getSimpleName()).fileNamePattern(fileNamePattern).pattern("%msg%n").build();
        }
        return loggerCreator;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

