/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.kawanfw.sql.api.server.logging.LoggerCreator;
import org.kawanfw.sql.servlet.util.logging.GenericLoggerCreator;
import org.kawanfw.sql.servlet.util.logging.LoggerCreatorProperties;
import org.kawanfw.sql.util.FrameworkDebug;
import org.slf4j.Logger;

public class DefaultLoggerCreator
implements LoggerCreator {
    private static boolean DEBUG = FrameworkDebug.isSet(DefaultLoggerCreator.class);
    private static final String MAIN_LOG_FILE_PATTERN = "aceql_%d.log.%i";
    private Logger logger;
    private Map<String, String> elements;

    public DefaultLoggerCreator() throws FileNotFoundException, IOException {
        LoggerCreatorProperties loggerCreatorProperties = LoggerCreatorProperties.getFileBasedProperties(DefaultLoggerCreator.class.getSimpleName());
        GenericLoggerCreator loggerCreator = null;
        if (loggerCreatorProperties != null) {
            String fileNamePattern = loggerCreatorProperties.getFileNamePattern();
            if (fileNamePattern == null) {
                fileNamePattern = MAIN_LOG_FILE_PATTERN;
            }
            loggerCreator = GenericLoggerCreator.newBuilder().name(DefaultLoggerCreator.class.getSimpleName()).fileNamePattern(fileNamePattern).pattern(loggerCreatorProperties.getPattern()).logDirectory(loggerCreatorProperties.getLogDirectory()).maxFileSize(loggerCreatorProperties.getMaxFileSize()).totalSizeCap(loggerCreatorProperties.getTotalSizeCap()).displayOnConsole(loggerCreatorProperties.isDisplayOnConsole()).displayLogStatusMessages(loggerCreatorProperties.isDisplayLogStatusMessages()).build();
        } else {
            loggerCreator = GenericLoggerCreator.newBuilder().name(DefaultLoggerCreator.class.getSimpleName()).fileNamePattern(MAIN_LOG_FILE_PATTERN).build();
        }
        this.elements = loggerCreator.getElements();
        this.logger = loggerCreator.getLogger();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Map<String, String> getElements() {
        return this.elements;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

