/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.session;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.server.session.SessionConfigurator;
import org.kawanfw.sql.api.server.session.SessionIdentifierGenerator;
import org.kawanfw.sql.api.server.session.SessionInfo;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.util.Tag;

public class DefaultSessionConfigurator
implements SessionConfigurator {
    private Properties properties = null;
    private SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
    private Map<String, SessionInfo> sessionInfoStore = new ConcurrentHashMap<String, SessionInfo>();

    @Override
    public String generateSessionId(String username, String database) {
        String sessionId = this.sessionIdentifierGenerator.nextSessionId();
        SessionInfo sessionInfo = new SessionInfo(sessionId, username, database);
        this.sessionInfoStore.put(sessionId, sessionInfo);
        return sessionId;
    }

    @Override
    public String getUsername(String sessionId) {
        SessionInfo sessionInfo = this.sessionInfoStore.get(sessionId);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getUsername();
    }

    @Override
    public String getDatabase(String sessionId) {
        SessionInfo sessionInfo = this.sessionInfoStore.get(sessionId);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getDatabase();
    }

    @Override
    public void remove(String sessionId) {
        this.sessionInfoStore.remove(sessionId);
    }

    @Override
    public boolean verifySessionId(String sessionId) throws IOException {
        SessionInfo sessionInfo = this.sessionInfoStore.get(sessionId);
        if (sessionInfo == null) {
            return false;
        }
        if (this.getSessionTimelifeMinutes() == 0) {
            return true;
        }
        return new Date().getTime() - sessionInfo.getCreationTimeMillis() <= (long)(this.getSessionTimelifeMinutes() * 60 * 1000);
    }

    @Override
    public int getSessionTimelifeMinutes() throws IOException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        return DefaultSessionConfigurator.getSessionTimelifeMinutesPropertyValue(this.properties);
    }

    static int getSessionTimelifeMinutesPropertyValue(Properties properties) throws IOException {
        Objects.requireNonNull(properties, String.valueOf(Tag.PRODUCT) + " properties cannot be null!");
        String sessionTimelifeInMinutesStr = properties.getProperty("session.timelifeMinutes");
        if (sessionTimelifeInMinutesStr == null) {
            return 0;
        }
        if (!StringUtils.isNumeric((CharSequence)sessionTimelifeInMinutesStr)) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT) + " The session.timelifeMinutes property is not numeric: " + sessionTimelifeInMinutesStr);
        }
        int sessionTimelifeMinutes = Integer.parseInt(sessionTimelifeInMinutesStr);
        return sessionTimelifeMinutes;
    }
}

