/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.session;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.kawanfw.sql.api.server.session.DefaultSessionConfigurator;
import org.kawanfw.sql.api.server.session.SessionConfigurator;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;

public class JwtSessionConfigurator
implements SessionConfigurator {
    private Properties properties = null;

    @Override
    public String generateSessionId(String username, String database) throws IOException {
        try {
            String secret = ConfPropertiesStore.get().getJwtSessionConfiguratorSecretValue();
            if (secret == null || secret.isEmpty()) {
                throw new IllegalArgumentException("The jwtSessionConfiguratorSecret property value defined in the AceQL properties file cannot be null.");
            }
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTCreator.Builder builder = JWT.create();
            builder.withClaim("usr", username);
            builder.withClaim("dbn", database);
            builder.withIssuedAt(new Date());
            if (this.getSessionTimelifeMinutes() != 0) {
                Date expiresAt = new Date(System.currentTimeMillis() + (long)(this.getSessionTimelifeMinutes() * 60 * 1000));
                builder.withExpiresAt(expiresAt);
            }
            String token = builder.sign(algorithm);
            return token;
        }
        catch (JWTCreationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public String getUsername(String sessionId) {
        try {
            DecodedJWT jwt = JWT.decode((String)sessionId);
            Map claims = jwt.getClaims();
            Claim claim = (Claim)claims.get("usr");
            return claim.asString();
        }
        catch (JWTDecodeException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String getDatabase(String sessionId) {
        try {
            DecodedJWT jwt = JWT.decode((String)sessionId);
            Map claims = jwt.getClaims();
            Claim claim = (Claim)claims.get("dbn");
            return claim.asString();
        }
        catch (JWTDecodeException exception) {
            System.err.println((Object)exception);
            return null;
        }
    }

    @Override
    public void remove(String sessionId) {
    }

    @Override
    public boolean verifySessionId(String sessionId) throws IOException {
        Date now;
        DecodedJWT jwt;
        block3: {
            try {
                String secret = ConfPropertiesStore.get().getJwtSessionConfiguratorSecretValue();
                Algorithm algorithm = Algorithm.HMAC256((String)secret);
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                jwt = verifier.verify(sessionId);
                if (this.getSessionTimelifeMinutes() != 0) break block3;
                return true;
            }
            catch (JWTVerificationException exception) {
                System.err.println((Object)exception);
                return false;
            }
        }
        Date issuedAt = jwt.getIssuedAt();
        return issuedAt == null || (now = new Date()).getTime() - issuedAt.getTime() <= (long)(this.getSessionTimelifeMinutes() * 60 * 1000);
    }

    @Override
    public int getSessionTimelifeMinutes() throws IOException {
        if (this.properties == null) {
            File file = PropertiesFileStore.get();
            this.properties = PropertiesFileUtil.getProperties(file);
        }
        return DefaultSessionConfigurator.getSessionTimelifeMinutesPropertyValue(this.properties);
    }
}

