/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class SimpleHttpClient {
    public static boolean TRACE_ON = false;
    private Proxy proxy = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private int httpStatusCode = 200;
    private String httpStatusMessage = null;

    public SimpleHttpClient(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String callWithPost(URL url, Map<String, String> parametersMap) throws IOException, ProtocolException, SocketTimeoutException, UnsupportedEncodingException {
        Objects.requireNonNull(url, "url cannot be null!");
        Objects.requireNonNull(parametersMap, "parametersMap cannot be null!");
        String result = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = this.callWithPostReturnStream(url, parametersMap);){
            if (in != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                result = out.toString("UTF-8");
                this.trace("result :" + result + ":");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String callWithGet(String url, Map<String, String> parametersMap) throws MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        String responseBody = null;
        String urlNew = url;
        if (parametersMap != null && !parametersMap.isEmpty()) {
            urlNew = String.valueOf(urlNew) + "?" + SimpleHttpClient.getPostDataString(parametersMap);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream in = this.callWithGetReturnStream(urlNew);){
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            responseBody = out.toString("UTF-8");
            if (responseBody != null) {
                responseBody = responseBody.trim();
            }
            this.trace("----------------------------------------");
            this.trace(responseBody);
            this.trace("----------------------------------------");
            return responseBody;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private InputStream callWithGetReturnStream(String url) throws MalformedURLException, IOException, ProtocolException {
        URL theUrl = new URL(url);
        HttpURLConnection conn = null;
        conn = this.proxy == null ? (HttpURLConnection)theUrl.openConnection() : (HttpURLConnection)theUrl.openConnection(this.proxy);
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        this.trace();
        this.trace("Executing request " + url);
        this.httpStatusCode = conn.getResponseCode();
        this.httpStatusMessage = conn.getResponseMessage();
        InputStream in = null;
        in = this.httpStatusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
        return in;
    }

    private InputStream callWithPostReturnStream(URL theUrl, Map<String, String> parameters) throws IOException, ProtocolException, SocketTimeoutException, UnsupportedEncodingException {
        HttpURLConnection conn = null;
        conn = this.proxy == null ? (HttpURLConnection)theUrl.openConnection() : (HttpURLConnection)theUrl.openConnection(this.proxy);
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream connOut = conn.getOutputStream();){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connOut, "UTF-8"));
            writer.write(SimpleHttpClient.getPostDataString(parameters));
            writer.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.trace();
        this.trace("Executing request: " + theUrl.toString());
        if (parameters.containsKey("sql")) {
            this.trace("sql..............: " + parameters.get("sql"));
        }
        this.trace("parameters.......: " + parameters);
        this.httpStatusCode = conn.getResponseCode();
        this.httpStatusMessage = conn.getResponseMessage();
        InputStream in = null;
        in = this.httpStatusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
        return in;
    }

    public static String getPostDataString(Map<String, String> requestParams) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            if (entry.getValue() == null) continue;
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getHttpStatusMessage() {
        return this.httpStatusMessage;
    }

    private void trace() {
        if (TRACE_ON) {
            System.out.println();
        }
    }

    private void trace(String s) {
        if (TRACE_ON) {
            System.out.println(s);
        }
    }
}

