/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.server.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class SimpleSha1 {
    public static String sha1(String text, boolean toLowerCase) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        byte[] sha1hash = new byte[40];
        try {
            md.update(text.getBytes("UTF-8"), 0, text.length());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        sha1hash = md.digest();
        String hexString = SimpleSha1.convertToHex(sha1hash);
        if (toLowerCase) {
            hexString = hexString.toLowerCase();
        }
        return hexString;
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
            ++i;
        }
        return buf.toString();
    }
}

