/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class JsqlParserWrapper {
    private Statement statement = null;
    private List<String> tables = new ArrayList<String>();
    private String statementName = null;
    private boolean isDCL = false;
    private boolean isDDL = false;
    private boolean isDML = false;
    private boolean isTCL = false;

    public JsqlParserWrapper(Statement statement) {
        this.statement = Objects.requireNonNull(statement, "statement cannot be null!");
        this.parse();
    }

    public void parse() {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        this.tables = tablesNamesFinder.getTableList(this.statement);
        this.isDCL = false;
        this.isDDL = false;
        this.isDML = false;
        this.isTCL = false;
        this.parse1();
        this.parse2();
        this.parse3();
        this.parse4();
        this.parse5();
        this.parse6();
    }

    private void parse6() {
        if (this.statement instanceof Upsert) {
            this.statementName = "UPSERT";
            this.isDML = true;
        } else if (this.statement instanceof UseStatement) {
            this.statementName = "USE";
            this.isDML = true;
        } else if (this.statement instanceof ValuesStatement) {
            this.statementName = "VALUES";
            this.isDML = true;
        } else {
            this.statementName = null;
        }
    }

    private void parse5() {
        if (this.statement instanceof SetStatement) {
            this.statementName = "SET";
            this.isDML = true;
        } else if (this.statement instanceof ShowColumnsStatement) {
            this.statementName = "SHOW COLUMNS";
            this.isDML = true;
        } else if (this.statement instanceof Truncate) {
            this.statementName = "TRUNCATE";
            this.isDDL = true;
        } else if (this.statement instanceof Update) {
            this.statementName = "UPDATE";
            this.isDML = true;
        }
    }

    private void parse4() {
        if (this.statement instanceof ExplainStatement) {
            this.statementName = "EXPLAIN";
            this.isDML = true;
        } else if (this.statement instanceof Insert) {
            this.statementName = "INSERT";
            this.isDML = true;
        } else if (this.statement instanceof Merge) {
            this.statementName = "MERGE";
            this.isDML = true;
        } else if (this.statement instanceof Replace) {
            this.statementName = "REPLACE";
            this.isDML = true;
        } else if (this.statement instanceof Select) {
            this.statementName = "SELECT";
            this.isDML = true;
        }
    }

    private void parse3() {
        if (this.statement instanceof Delete) {
            this.statementName = "DELETE";
            this.isDML = true;
        } else if (this.statement instanceof DescribeStatement) {
            this.statementName = "DESCRIBE";
            this.isDML = true;
        } else if (this.statement instanceof Drop) {
            this.statementName = "DROP";
            this.isDDL = true;
        } else if (this.statement instanceof Execute) {
            this.statementName = "EXECUTE";
            this.isDML = true;
        }
    }

    private void parse2() {
        if (this.statement instanceof CreateIndex) {
            this.statementName = "CREATE";
            this.isDDL = true;
        } else if (this.statement instanceof CreateTable) {
            this.statementName = "CREATE";
            this.isDDL = true;
        } else if (this.statement instanceof CreateView) {
            this.statementName = "CREATE";
            this.isDDL = true;
        } else if (this.statement instanceof DeclareStatement) {
            this.statementName = "DECLARE";
            this.isDML = true;
        }
    }

    private void parse1() {
        if (this.statement instanceof Alter) {
            this.statementName = "ALTER";
            this.isDDL = true;
        } else if (this.statement instanceof AlterView) {
            this.statementName = "ALTER";
            this.isDDL = true;
        } else if (this.statement instanceof Block) {
            this.statementName = "BLOCK";
            this.isDML = true;
        } else if (this.statement instanceof Comment) {
            this.statementName = "COMMENT";
            this.isDDL = true;
        } else if (this.statement instanceof Commit) {
            this.statementName = "COMMIT";
            this.isTCL = true;
        }
    }

    public List<String> getTables() {
        return this.tables;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public boolean isDCL() {
        return this.isDCL;
    }

    public boolean isDDL() {
        return this.isDDL;
    }

    public boolean isDML() {
        return this.isDML;
    }

    public boolean isTCL() {
        return this.isTCL;
    }
}

