/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkDebug;

public class PreparedStatementRunner {
    private static boolean DEBUG = FrameworkDebug.isSet(PreparedStatementRunner.class);
    private static String CR_LF = System.getProperty("line.separator");
    private static final String WHERE = "where";
    private static final String INSERT = "insert";
    private static final String DELETE = "delete";
    private static final String UPDATE = "update";
    private static final String SELECT = "select";
    private Connection connection = null;
    private PreparedStatement prepStatement = null;
    private ResultSet rs = null;
    private String sql = null;
    private List<Object> params = new Vector<Object>();
    private String developedQuery = null;

    public PreparedStatementRunner(Connection connection, String sql, Object ... params) {
        if (connection == null) {
            throw new IllegalArgumentException("connection can't be null");
        }
        if (sql == null) {
            throw new IllegalArgumentException("sql preparement statement string can't be null");
        }
        this.sql = sql;
        this.sql = this.sql.trim();
        while (this.sql.endsWith(";")) {
            this.sql = StringUtils.removeEnd((String)this.sql, (String)";");
        }
        this.developedQuery = sql;
        int i = 0;
        while (i < params.length) {
            this.params.add(params[i]);
            String strParam = params[i].toString();
            this.developedQuery = this.developedQuery.replaceFirst("\\?", strParam);
            ++i;
        }
        this.connection = connection;
    }

    public ResultSet executeQuery() throws SQLException {
        int numberOfParams;
        this.prepStatement = this.connection.prepareStatement(this.sql, 1004, 1007);
        int numberOfIntMarks = StringUtils.countMatches((CharSequence)this.sql, (CharSequence)"?");
        if (numberOfIntMarks != (numberOfParams = this.params.size())) {
            throw new SQLException("sql statement numbers of \"?\" do no match number of parameters: " + numberOfIntMarks + " and " + numberOfParams);
        }
        int i = 0;
        while (i < this.params.size()) {
            int j = i + 1;
            this.prepStatement.setObject(j, this.params.get(i));
            ++i;
        }
        this.rs = null;
        if (!this.sql.toLowerCase().startsWith(SELECT)) {
            throw new SQLException("sql string is not a query: " + this.sql);
        }
        PreparedStatementRunner.debug("sql query for prepStatement.executeQuery(): " + CR_LF + this.sql);
        this.rs = this.prepStatement.executeQuery();
        return this.rs;
    }

    public int executeUpdate() throws SQLException {
        int numberOfParams;
        this.prepStatement = this.connection.prepareStatement(this.sql);
        int numberOfIntMarks = StringUtils.countMatches((CharSequence)this.sql, (CharSequence)"?");
        if (numberOfIntMarks != (numberOfParams = this.params.size())) {
            throw new SQLException("sql statement numbers of \"?\" do no match number of parameters: " + numberOfIntMarks + " and " + numberOfParams);
        }
        int i = 0;
        while (i < this.params.size()) {
            int j = i + 1;
            this.prepStatement.setObject(j, this.params.get(i));
            ++i;
        }
        int rc = -1;
        String sqlLower = this.sql.toLowerCase();
        if (sqlLower.startsWith(SELECT)) {
            throw new SQLException("sql string is not an update: " + this.sql);
        }
        if (sqlLower.startsWith(UPDATE) || sqlLower.startsWith(DELETE) && sqlLower.indexOf(" where ") == 0) {
            throw new SQLException("update and delete are not permitted without a WHERE clause: " + this.sql);
        }
        if (!(sqlLower.startsWith(UPDATE) || sqlLower.startsWith(DELETE) || sqlLower.startsWith(INSERT))) {
            throw new SQLException("Statement is not INSERT / UPDATE / DELETE: " + this.sql);
        }
        rc = this.prepStatement.executeUpdate();
        PreparedStatementRunner.debug(this.toString());
        return rc;
    }

    public String getDevelopedQuery() {
        return this.developedQuery;
    }

    public String toString() {
        String string = "Initial query..: " + this.sql + CR_LF + "Parameters.....: " + this.params.toString() + CR_LF + "DevelopedQuery : " + CR_LF + this.developedQuery;
        return string;
    }

    public void close() {
        try {
            if (this.prepStatement != null) {
                this.prepStatement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

