/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kawanfw.sql.util.FrameworkDebug;

public class ResultSetPrinter {
    private static boolean DEBUG = FrameworkDebug.isSet(ResultSetPrinter.class);
    private static String CR_LF = System.getProperty("line.separator");
    private Map<Integer, Integer> columnWidth = new ConcurrentHashMap<Integer, Integer>();
    private ResultSet resultSet = null;
    private PrintStream printStream = null;
    private boolean formatForCSV = false;

    public ResultSetPrinter(ResultSet resultSet, PrintStream printStream, boolean formatForCSV) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet can not be null!");
        }
        if (printStream == null) {
            throw new IllegalArgumentException("printStream can not be null!");
        }
        this.resultSet = resultSet;
        this.printStream = printStream;
        this.formatForCSV = formatForCSV;
    }

    public ResultSetPrinter(ResultSet resultSet, PrintStream printStream) {
        this(resultSet, printStream, false);
    }

    private void computeColumnMaxWidth() throws SQLException {
        ResultSetMetaData meta = this.resultSet.getMetaData();
        int cols = meta.getColumnCount();
        int i = 1;
        while (i <= cols) {
            String label = meta.getColumnLabel(i);
            label = label.trim();
            int length = label.length();
            this.columnWidth.put(i, length + 2);
            ++i;
        }
        while (this.resultSet.next()) {
            i = 1;
            while (i <= cols) {
                int length;
                Object value = this.resultSet.getObject(i);
                String strNoTrim = null;
                strNoTrim = this.resultSet.wasNull() ? "NULL" : (value == null ? "" : value.toString());
                String str = this.getFirstLineOfText(strNoTrim);
                str = str.trim();
                ResultSetPrinter.debug("str:" + str);
                int colType = meta.getColumnType(i);
                if (str.startsWith("**!kawanfw_stream_file!**") && (ResultSetPrinter.isBinaryColumn(colType) || colType == -5)) {
                    str = this.getBinaryDataMessage();
                }
                if ((length = str.length()) + 2 > this.columnWidth.get(i)) {
                    this.columnWidth.put(i, length + 2);
                }
                ++i;
            }
        }
    }

    public String getBinaryDataMessage() {
        return "(binary data)";
    }

    private String getFirstLineOfText(String str) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(str));
        String line = null;
        try {
            line = bufferedReader.readLine();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return line;
    }

    public void print() throws SQLException {
        int size;
        int colType;
        this.resultSet.beforeFirst();
        this.computeColumnMaxWidth();
        this.resultSet.beforeFirst();
        ResultSetMetaData meta = this.resultSet.getMetaData();
        StringBuffer bar = new StringBuffer();
        StringBuffer buffer = new StringBuffer();
        int cols = meta.getColumnCount();
        int row_count = 0;
        int width = 0;
        int i = 1;
        while (i <= cols) {
            width += this.columnWidth.get(i).intValue();
            ++i;
        }
        width += 1 + cols;
        i = 0;
        while (i < width - 2) {
            bar.append('-');
            ++i;
        }
        i = 1;
        while (i <= cols) {
            String label = meta.getColumnLabel(i);
            String colTypeName = meta.getColumnTypeName(i);
            colType = meta.getColumnType(i);
            ResultSetPrinter.debug("");
            size = this.columnWidth.get(i);
            ResultSetPrinter.debug("Column Label     : " + label);
            ResultSetPrinter.debug("Column size      : " + size);
            ResultSetPrinter.debug("Column type      : " + colType);
            ResultSetPrinter.debug("Column type name : " + colTypeName);
            if (!this.formatForCSV) {
                label = this.fillHeaderWithBlanks(label, size);
                buffer.append(label);
                if (i < cols) {
                    buffer.append("|");
                }
            } else {
                buffer.append(label);
                if (i < cols) {
                    buffer.append(";");
                }
            }
            ++i;
        }
        if (!this.formatForCSV) {
            buffer.append(String.valueOf(CR_LF) + bar.toString());
        }
        String bufferheader = buffer.toString();
        this.printStream.println(bufferheader);
        while (this.resultSet.next()) {
            buffer = new StringBuffer();
            ++row_count;
            i = 1;
            while (i <= cols) {
                Object value = this.resultSet.getObject(i);
                colType = meta.getColumnType(i);
                size = this.columnWidth.get(i);
                String strNoTrim = null;
                strNoTrim = this.resultSet.wasNull() ? "NULL" : (value == null ? "" : value.toString());
                String str = this.getFirstLineOfText(strNoTrim);
                if ((str = str.trim()).startsWith("**!kawanfw_stream_file!**") && (ResultSetPrinter.isBinaryColumn(colType) || colType == -5)) {
                    str = this.getBinaryDataMessage();
                }
                if (!this.formatForCSV) {
                    str = this.fillValueWithBlanks(size, str, colType);
                    buffer.append(str);
                    if (i < cols) {
                        buffer.append("|");
                    }
                } else {
                    str = str.replace(';', ',');
                    buffer.append(str);
                    if (i < cols) {
                        buffer.append(";");
                    }
                }
                ++i;
            }
            String bufferLine = buffer.toString();
            this.printStream.println(bufferLine);
        }
        if (!this.formatForCSV) {
            String query_trailer = new String();
            query_trailer = "(" + row_count + " rows)";
            this.printStream.println(query_trailer);
        }
    }

    private static boolean isBinaryColumn(int columnType) {
        return columnType == -2 || columnType == -3 || columnType == -4 || columnType == 2004;
    }

    private static boolean isColumnNumeric(int colType) {
        return colType == -6 || colType == 5 || colType == 4 || colType == -5 || colType == 6 || colType == 7 || colType == 2 || colType == 3;
    }

    /*
     * Unable to fully structure code
     */
    private String fillValueWithBlanks(int size, String str, int colType) {
        block3: {
            filler = new StringBuffer();
            if (str.length() > size) {
                str = str.substring(0, size);
            }
            if (str.length() >= size) break block3;
            x = 1;
            j = 0;
            while (j < x) {
                filler.append(" ");
                ++j;
            }
            str = filler + str + filler;
            if (str.length() <= size) ** GOTO lbl17
            str = str.substring(0, size);
            break block3;
lbl-1000:
            // 1 sources

            {
                str = ResultSetPrinter.isColumnNumeric(colType) != false ? " " + str : String.valueOf(str) + " ";
lbl17:
                // 2 sources

                ** while (str.length() < size)
            }
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    private String fillHeaderWithBlanks(String label, int size) {
        block3: {
            filler = new StringBuffer();
            if (label.length() > size) {
                label = label.substring(0, size);
            }
            if (label.length() >= size) break block3;
            x = 1;
            j = 0;
            while (j < x) {
                filler.append(' ');
                ++j;
            }
            label = filler + label + filler;
            if (label.length() <= size) ** GOTO lbl17
            label = label.substring(0, size);
            break block3;
lbl-1000:
            // 1 sources

            {
                label = String.valueOf(label) + " ";
lbl17:
                // 2 sources

                ** while (label.length() < size)
            }
        }
        return label;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

