/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class SqlUtil {
    public static final String ACCESS = "ACCESS";
    public static final String ADAPTIVE_SERVER_ENTERPRISE = "Adaptive Server Enterprise";
    public static final String DB2 = "DB2";
    public static final String H2 = "H2";
    public static final String HSQLDB = "HSQL Database Engine";
    public static final String INFORMIX = "Informix Dynamic Server";
    public static final String INGRES = "INGRES";
    public static final String MYSQL = "MySQL";
    public static final String ORACLE = "Oracle";
    public static final String POSTGRESQL = "PostgreSQL";
    public static final String SQL_ANYWHERE = "SQL Anywhere";
    public static final String SQL_SERVER = "SQL Server";
    public static final String TERADATA = "Teradata";
    private String databaseProductName = null;

    public SqlUtil(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection can not be null!");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.databaseProductName = databaseMetaData.getDatabaseProductName();
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public boolean isAccess() {
        return this.isProduct(ACCESS);
    }

    public boolean isAdaptiveServerEnterprise() {
        return this.isProduct(ADAPTIVE_SERVER_ENTERPRISE);
    }

    public boolean isDB2() {
        return this.isProduct(DB2);
    }

    public boolean isHSQLDB() {
        return this.isProduct(HSQLDB);
    }

    public boolean isH2() {
        return this.isProduct(H2);
    }

    public boolean isInformix() {
        return this.isProduct(INFORMIX);
    }

    public boolean isIngres() {
        return this.isProduct(INGRES);
    }

    public boolean isMySQL() {
        return this.isProduct(MYSQL);
    }

    public boolean isOracle() {
        return this.isProduct(ORACLE);
    }

    public boolean isPostgreSQL() {
        return this.isProduct(POSTGRESQL);
    }

    public boolean isSQLAnywhere() {
        return this.isProduct(SQL_ANYWHERE);
    }

    public boolean isSQLServer() {
        return this.isProduct(SQL_SERVER);
    }

    public boolean isTeradata() {
        return this.isProduct(TERADATA);
    }

    private boolean isProduct(String product) {
        return this.databaseProductName.toLowerCase().contains(product.toLowerCase());
    }

    public static String listToSqlList(List<?> objects) {
        StringBuffer sb = new StringBuffer();
        String sQuote = objects.get(0) instanceof String ? "'" : "";
        int i = 0;
        while (i < objects.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(sQuote);
            sb.append(objects.get(i));
            sb.append(sQuote);
            ++i;
        }
        return sb.toString();
    }
}

