/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.auth;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.EnvironmentStringDigesterConfig;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.StringFixedSaltGenerator;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;

public class ConfigurablePasswordEncryptorUtil {
    public static final String DEFAULT_AUTHENTICATION_QUERY = "SELECT encrypted_password FROM users WHERE username = ?";
    public static final int DEFAULT_HASH_ITERATIONS = 1;
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";
    public static final String DEFAULT_SAULT = null;

    public static ConfigurablePasswordEncryptor getConfigurablePasswordEncryptor(Properties properties) throws IOException {
        String hashIterationsStr;
        Objects.requireNonNull(properties, "properties cannot be null!");
        String hashAlgorithm = properties.getProperty("jdbcUserAuthenticator.hashAlgorithm");
        if (hashAlgorithm == null || hashAlgorithm.isEmpty()) {
            hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        }
        if ((hashIterationsStr = properties.getProperty("jdbcUserAuthenticator.hashIterations")) == null || hashIterationsStr.isEmpty()) {
            hashIterationsStr = "1";
        }
        if (!StringUtils.isNumeric((CharSequence)hashIterationsStr)) {
            throw new IOException("[USER CONFIGURATION]. jdbcUserAuthenticator.hashIterations property value is not numeric : " + hashIterationsStr);
        }
        String salt = properties.getProperty("jdbcUserAuthenticator.salt");
        if (salt == null || salt.isEmpty()) {
            salt = DEFAULT_SAULT;
        }
        ConfigurablePasswordEncryptor passwordEncryptor = new ConfigurablePasswordEncryptor();
        passwordEncryptor.setStringOutputType("hexadecimal");
        EnvironmentStringDigesterConfig digesterConfig = new EnvironmentStringDigesterConfig();
        digesterConfig.setAlgorithm(hashAlgorithm);
        if (salt == null) {
            digesterConfig.setSaltSizeBytes(Integer.valueOf(0));
        } else {
            digesterConfig.setSaltGenerator((SaltGenerator)new StringFixedSaltGenerator(salt));
        }
        digesterConfig.setIterations(Integer.valueOf(Integer.parseInt(hashIterationsStr)));
        passwordEncryptor.setConfig((DigesterConfig)digesterConfig);
        return passwordEncryptor;
    }
}

