/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.kawanfw.sql.api.util.firewall.DatabaseUserTableTriplet;
import org.kawanfw.sql.api.util.firewall.FirstLineChecker;
import org.kawanfw.sql.api.util.firewall.IllegalFirstLineException;
import org.kawanfw.sql.api.util.firewall.IllegalStatementAllowBooleanValue;
import org.kawanfw.sql.api.util.firewall.IllegalTableNameException;
import org.kawanfw.sql.api.util.firewall.TableAllowStatements;

public class CsvRulesManagerLoader {
    private static final int HEADER_LINE_NB_ELEMENTS = 7;
    private File file = null;
    private String database = null;
    private Set<String> tableSet = null;
    private Map<DatabaseUserTableTriplet, TableAllowStatements> mapTableAllowStatementsSet = new ConcurrentSkipListMap<DatabaseUserTableTriplet, TableAllowStatements>();
    private Set<TableAllowStatements> tableAllowStatementsSet = new ConcurrentSkipListSet<TableAllowStatements>();

    public CsvRulesManagerLoader(File file, String database, Set<String> tableSet) {
        this.database = Objects.requireNonNull(database, "file cannot be null!");
        this.file = Objects.requireNonNull(file, "file cannot be null!");
        this.tableSet = Objects.requireNonNull(tableSet, "tableSet cannot be null!");
    }

    public void load() throws IOException, FileNotFoundException {
        if (!this.file.exists()) {
            throw new FileNotFoundException("The file does not exist: " + this.file);
        }
        this.checkFileIntegrity();
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
            bufferedReader.readLine();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                DatabaseUserTableTriplet databaseUserTableTriplet = this.databaseUserTableTripletBuild(line);
                TableAllowStatements tableAllowStatements = this.tableAllowStatementsBuild(line);
                this.tableAllowStatementsSet.add(tableAllowStatements);
                this.mapTableAllowStatementsSet.put(databaseUserTableTriplet, tableAllowStatements);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private DatabaseUserTableTriplet databaseUserTableTripletBuild(String line) {
        String[] elements = line.split(";");
        int i = 0;
        String username = elements[i++];
        String table = elements[i++];
        DatabaseUserTableTriplet databaseUserTableTriplet = new DatabaseUserTableTriplet(this.database, username, table);
        return databaseUserTableTriplet;
    }

    private TableAllowStatements tableAllowStatementsBuild(String line) {
        String[] elements = line.split(";");
        int i = 0;
        String username = elements[i++];
        String table = elements[i++];
        boolean delete = Boolean.parseBoolean(elements[i++]);
        boolean insert = Boolean.parseBoolean(elements[i++]);
        boolean select = Boolean.parseBoolean(elements[i++]);
        boolean update = Boolean.parseBoolean(elements[i++]);
        TableAllowStatements tableAllowStatements = new TableAllowStatements(this.database, username, table, delete, insert, select, update);
        return tableAllowStatements;
    }

    private void checkFileIntegrity() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
            String line = null;
            line = bufferedReader.readLine();
            FirstLineChecker firstLineChecker = new FirstLineChecker(this.file, line);
            firstLineChecker.checkValues();
            int lineNumber = 1;
            while ((line = bufferedReader.readLine()) != null) {
                this.checkCurrentLineIntegrity(line, lineNumber++);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkCurrentLineIntegrity(String line, int lineNumber) {
        String table;
        String[] elements = line.split(";");
        if (elements.length != 7 && elements.length != 6) {
            throw new IllegalFirstLineException(this.file, "There must be 7 or 6 values in CSV file current line. Incorrect line: " + line);
        }
        int i = 1;
        if (!this.tableSet.contains(table = elements[i++].toLowerCase())) {
            throw new IllegalTableNameException(this.file, table, lineNumber);
        }
        String value = null;
        if (!this.isStrictBooleanValue(value = elements[i++].toLowerCase())) {
            throw new IllegalStatementAllowBooleanValue(this.file, value, "delete", lineNumber);
        }
        if (!this.isStrictBooleanValue(value = elements[i++].toLowerCase())) {
            throw new IllegalStatementAllowBooleanValue(this.file, value, "insert", lineNumber);
        }
        if (!this.isStrictBooleanValue(value = elements[i++].toLowerCase())) {
            throw new IllegalStatementAllowBooleanValue(this.file, value, "select", lineNumber);
        }
        if (!this.isStrictBooleanValue(value = elements[i++].toLowerCase())) {
            throw new IllegalStatementAllowBooleanValue(this.file, value, "update", lineNumber);
        }
    }

    private boolean isStrictBooleanValue(String booleanValue) {
        if (booleanValue == null) {
            return false;
        }
        return booleanValue.toLowerCase().contentEquals("false") || booleanValue.toLowerCase().contentEquals("true");
    }

    public Map<DatabaseUserTableTriplet, TableAllowStatements> getMapTableAllowStatementsSet() {
        return this.mapTableAllowStatementsSet;
    }

    public Set<TableAllowStatements> getTableAllowStatementsSet() {
        return this.tableAllowStatementsSet;
    }

    public static void main(String[] argv) throws Exception {
        String database = "sampledb";
        HashSet<String> tableSet = new HashSet<String>();
        tableSet.add("all");
        tableSet.add("banned_usernames");
        tableSet.add("customer");
        tableSet.add("orderlog");
        tableSet.add("documentation");
        File file = new File("I:\\_dev_awake\\aceql-http-main\\aceql-http\\conf\\sampledb_rules_manager.csv");
        CsvRulesManagerLoader csvRulesManagerLoader = new CsvRulesManagerLoader(file, database, tableSet);
        csvRulesManagerLoader.load();
        Map<DatabaseUserTableTriplet, TableAllowStatements> mapTableAllowStatements = csvRulesManagerLoader.getMapTableAllowStatementsSet();
        for (Map.Entry<DatabaseUserTableTriplet, TableAllowStatements> entry : mapTableAllowStatements.entrySet()) {
            DatabaseUserTableTriplet triplet = entry.getKey();
            TableAllowStatements tableAllowStatements = entry.getValue();
            System.out.println(triplet + " / " + tableAllowStatements);
        }
        System.out.println();
        Set<TableAllowStatements> tableAllowStatementsSet = csvRulesManagerLoader.getTableAllowStatementsSet();
        for (TableAllowStatements tableAllowStatements : tableAllowStatementsSet) {
            System.out.println(tableAllowStatements);
        }
    }
}

