/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.io.File;
import org.kawanfw.sql.api.util.firewall.IllegalFirstLineException;

public class FirstLineChecker {
    private static final int HEADER_LINE_NB_ELEMENTS = 7;
    private File file = null;
    private String line = null;
    String username;
    String table;
    String delete;
    String insert;
    String select;
    String update;
    String optionalComments;

    public FirstLineChecker(File file, String line) {
        this.file = file;
        this.line = line;
        this.treat();
    }

    private void treat() {
        String[] elements = this.line.split(";");
        if (elements.length != 7) {
            throw new IllegalFirstLineException(this.file, "There must be 7 column names in CSV file header line. Incorrect header line: " + this.line);
        }
        int i = 0;
        this.username = elements[i++];
        this.table = elements[i++];
        this.delete = elements[i++];
        this.insert = elements[i++];
        this.select = elements[i++];
        this.update = elements[i++];
        this.optionalComments = elements[i++];
    }

    public void checkValues() {
        if (!this.username.equalsIgnoreCase("username")) {
            throw new IllegalFirstLineException(this.file, "Missing \"username\" first column on first line.");
        }
        if (!this.table.equalsIgnoreCase("table")) {
            throw new IllegalFirstLineException(this.file, "Missing \"table\" second column on first line.");
        }
        if (!this.delete.equalsIgnoreCase("delete")) {
            throw new IllegalFirstLineException(this.file, "Missing \"delete\" third column on first line.");
        }
        if (!this.insert.equalsIgnoreCase("insert")) {
            throw new IllegalFirstLineException(this.file, "Missing \"insert\" fourth column on first line.");
        }
        if (!this.select.equalsIgnoreCase("select")) {
            throw new IllegalFirstLineException(this.file, "Missing \"select\" fifth column on first line.");
        }
        if (!this.update.equalsIgnoreCase("update")) {
            throw new IllegalFirstLineException(this.file, "Missing \"update\" sixth column on first line.");
        }
        if (!this.optionalComments.equalsIgnoreCase("optional comments")) {
            throw new IllegalFirstLineException(this.file, "Missing \"optional comments\" seventh column on first line.");
        }
    }
}

