/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.kawanfw.sql.api.server.StatementNormalizer;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.util.logging.StringFlattener;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.TimestampUtil;

public class LearningModeExecutor {
    public static boolean DEBUG = FrameworkDebug.isSet(LearningModeExecutor.class);
    public static String CR_LF = System.getProperty("line.separator");

    public static synchronized void learn(String sqlOrder, String database) throws SQLException {
        try {
            BufferedWriter writer;
            Object var10_13;
            Throwable throwable;
            File propertiesFile = PropertiesFileStore.get();
            File learningFile = LearningModeExecutor.getLearningFile(database, propertiesFile);
            File logFile = new File(String.valueOf(learningFile.toString()) + ".errors.log");
            LinkedHashSet<String> lineSet = new LinkedHashSet<String>();
            if (learningFile.exists()) {
                List lines = FileUtils.readLines((File)learningFile, (String)"UTF-8");
                lineSet = new LinkedHashSet(lines);
            }
            StatementNormalizer statementNormalizer = new StatementNormalizer(sqlOrder);
            String sql = statementNormalizer.getNormalized();
            StringFlattener stringFlattener = new StringFlattener(sql);
            sql = stringFlattener.flatten();
            LearningModeExecutor.debug("sql: " + sql);
            LearningModeExecutor.debug("statementNormalizer.getException(): " + statementNormalizer.getException());
            if (!statementNormalizer.isSuccess()) {
                throwable = null;
                var10_13 = null;
                try {
                    writer = new BufferedWriter(new FileWriter(logFile, true));
                    try {
                        String message = String.valueOf(TimestampUtil.getHumanTimestampNow()) + " Reason: " + statementNormalizer.getException().getMessage() + " - SQL:  " + sql;
                        writer.write(String.valueOf(message) + CR_LF);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            lineSet.add(sql);
            throwable = null;
            var10_13 = null;
            try {
                writer = new BufferedWriter(new FileWriter(learningFile));
                try {
                    for (String line : lineSet) {
                        writer.write(String.valueOf(line) + CR_LF);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SQLException("Error when accessing learning file for database " + database + ": " + ioe.getMessage());
        }
    }

    private static File getLearningFile(String database, File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "file cannot be null!");
        if (!file.exists()) {
            throw new FileNotFoundException("The properties file does not exist: " + file);
        }
        File dir = file.getParentFile();
        File learningFile = new File(dir + File.separator + database + "_deny_except_whitelist.txt");
        return learningFile;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

