/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.firewall.trigger.SqlFirewallTrigger;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;

public class SqlFirewallTriggerWrapper {
    public static void runIfStatementRefused(SqlEvent sqlEvent, SqlFirewallManager sqlFirewallManager, Connection connection) throws IOException, SQLException {
        Objects.requireNonNull(sqlEvent, "sqlEvent cannot be null!");
        Objects.requireNonNull(sqlFirewallManager, "sqlFirewallManager cannot be null!");
        Objects.requireNonNull(connection, "connection cannot be null!");
        String database = sqlEvent.getDatabase();
        Set<SqlFirewallTrigger> sqlFirewallTriggers = InjectedClassesStore.get().getSqlFirewallTriggerMap().get(database);
        for (SqlFirewallTrigger sqlFirewallTrigger : sqlFirewallTriggers) {
            sqlFirewallTrigger.runIfStatementRefused(sqlEvent, sqlFirewallManager, connection);
        }
    }
}

