/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.util.Objects;

public class TableAllowStatements
implements Comparable<TableAllowStatements> {
    private String database = null;
    private String username = null;
    private String table = null;
    private boolean delete = false;
    private boolean insert = false;
    private boolean select = false;
    private boolean update = false;

    public TableAllowStatements(String database, String username, String table, boolean delete, boolean insert, boolean select, boolean update) {
        this.database = Objects.requireNonNull(database, "database cannot be null!");
        this.username = Objects.requireNonNull(username, "username cannot be null!");
        this.table = Objects.requireNonNull(table, "table cannot be null!");
        this.delete = delete;
        this.insert = insert;
        this.select = select;
        this.update = update;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isDeleteAllowed() {
        return this.delete;
    }

    public boolean isInsertAllowe() {
        return this.insert;
    }

    public boolean isSelectAllowed() {
        return this.select;
    }

    public boolean isUpdateAllowed() {
        return this.update;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableAllowStatements other = (TableAllowStatements)obj;
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    @Override
    public int compareTo(TableAllowStatements other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return "[database=" + this.database + ", username=" + this.username + ", table=" + this.table + ", delete=" + this.delete + ", insert=" + this.insert + ", select=" + this.select + ", update=" + this.update + "]";
    }
}

