/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.kawanfw.sql.api.server.StatementNormalizer;
import org.kawanfw.sql.util.Tag;

public class TextStatementsListLoader {
    private File file = null;
    private Set<String> normalizedStatementSet = new HashSet<String>();

    public TextStatementsListLoader(File file) {
        this.file = Objects.requireNonNull(file, "file cannot be null!");
    }

    public void load() throws IOException, FileNotFoundException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(String.valueOf(Tag.PRODUCT_USER_CONFIG_FAIL) + " The file does not exist: " + this.file);
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                StatementNormalizer statementNormalizer = new StatementNormalizer(line);
                String normalizedStatement = statementNormalizer.getNormalized();
                this.normalizedStatementSet.add(normalizedStatement);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Set<String> getNormalizedStatementSet() {
        return this.normalizedStatementSet;
    }
}

