/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall.cloudmersive;

import com.cloudmersive.client.TextInputApi;
import com.cloudmersive.client.invoker.ApiCallback;
import com.cloudmersive.client.invoker.ApiClient;
import com.cloudmersive.client.invoker.ApiException;
import com.cloudmersive.client.invoker.Configuration;
import com.cloudmersive.client.invoker.auth.ApiKeyAuth;
import com.cloudmersive.client.model.SqlInjectionDetectionResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.cloudmersive.SqlInjectionApiCallback;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.util.FrameworkDebug;

public class CloudmersiveApi {
    private static boolean DEBUG = FrameworkDebug.isSet(CloudmersiveApi.class);
    private static final int FIVE_MINUTES_IN_MILLISECONDS = 300000;
    private TextInputApi apiInstance;
    private String detectionLevel;
    private long snapshot;
    private File file;

    public CloudmersiveApi(File file) throws FileNotFoundException {
        this.file = Objects.requireNonNull(file, "file cannot be null!");
        if (!file.exists()) {
            throw new FileNotFoundException("The Cloudmersive elements file does not exist: " + file);
        }
        this.snapshot = 0L;
    }

    private void connect() throws IOException {
        long begin = System.currentTimeMillis();
        this.debug("Begin Connect...");
        Properties properties = PropertiesFileUtil.getProperties(this.file);
        String apiKey = (String)properties.get("apiKey");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IllegalArgumentException("[USER CONFIGURATION] apiKey property not found in file: " + this.file);
        }
        String apiKeyPrefix = (String)properties.get("apiKeyPrefix");
        this.detectionLevel = (String)properties.get("detectionLevel");
        if (this.detectionLevel == null || this.detectionLevel.isEmpty()) {
            this.detectionLevel = "Normal";
        }
        if (!this.detectionLevel.equals("High") && !this.detectionLevel.equals("Normal")) {
            throw new IllegalArgumentException("[USER CONFIGURATION] detectionLevel can be \"Normal\" or \"High\" only. Is: " + this.detectionLevel);
        }
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        ApiKeyAuth Apikey = (ApiKeyAuth)defaultClient.getAuthentication("Apikey");
        Apikey.setApiKey(apiKey);
        if (apiKeyPrefix != null && !apiKeyPrefix.isEmpty()) {
            Apikey.setApiKeyPrefix(apiKeyPrefix);
        }
        this.apiInstance = new TextInputApi();
        this.snapshot = new Date().getTime();
        long end = System.currentTimeMillis();
        this.debug("End Connect. " + (end - begin));
    }

    public boolean sqlInjectionDetect(String sql) throws SQLException, IOException {
        Objects.requireNonNull(sql, "sql cannot ne null!");
        long now = new Date().getTime();
        if (now - this.snapshot > 300000L) {
            this.debug("Reloading with connect()!");
            this.connect();
        }
        try {
            this.debug("Detecting SQLI in sql: " + sql);
            long begin = System.currentTimeMillis();
            SqlInjectionDetectionResult sqlInjectionDetectionResult = this.apiInstance.textInputCheckSqlInjection(sql, this.detectionLevel);
            boolean attack = sqlInjectionDetectionResult.isContainedSqlInjectionAttack();
            this.debug("attack: " + attack + " Detection time: " + (begin - System.currentTimeMillis()));
            return attack;
        }
        catch (ApiException apiException) {
            this.connect();
            throw new SQLException(apiException);
        }
    }

    public void sqlInjectionDetectAsync(SqlEvent sqlEvent, SqlFirewallManager sqlFirewallManager) throws IOException, SQLException {
        Objects.requireNonNull(sqlEvent, "sqlEvent cannot ne null!");
        Objects.requireNonNull(sqlFirewallManager, "sqlFirewallManager cannot ne null!");
        long now = new Date().getTime();
        if (now - this.snapshot > 300000L) {
            this.debug("Reloading with connect()!");
            this.connect();
        }
        try {
            this.debug("Detecting Async SQLI in sql: " + sqlEvent.getSql());
            SqlInjectionApiCallback sqlInjectionApiCallback = new SqlInjectionApiCallback(sqlEvent, sqlFirewallManager);
            this.apiInstance.textInputCheckSqlInjectionAsync(sqlEvent.getSql(), this.detectionLevel, (ApiCallback)sqlInjectionApiCallback);
        }
        catch (ApiException apiException) {
            this.connect();
            throw new SQLException(apiException);
        }
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(new Date() + " " + this.getClass().getSimpleName() + " " + string);
        }
    }
}

