/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.api.util.firewall.cloudmersive;

import com.cloudmersive.client.invoker.ApiCallback;
import com.cloudmersive.client.invoker.ApiException;
import com.cloudmersive.client.model.SqlInjectionDetectionResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.util.FrameworkDebug;

public class SqlInjectionApiCallback
implements ApiCallback<SqlInjectionDetectionResult> {
    private static boolean DEBUG = FrameworkDebug.isSet(SqlInjectionApiCallback.class);
    private SqlEvent sqlEvent;
    private SqlFirewallManager sqlFirewallManager;

    public SqlInjectionApiCallback(SqlEvent sqlEvent, SqlFirewallManager sqlFirewallManager) {
        this.sqlEvent = Objects.requireNonNull(sqlEvent, "sqlEvent cannot ne null!");
        this.sqlFirewallManager = Objects.requireNonNull(sqlFirewallManager, "sqlFirewallManager cannot ne null!");
    }

    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        System.err.println();
        System.err.println("Cloudmersive failure on DenySqlInjectionManagerAsync defered execution: ");
        System.err.println("sqlEvent           : " + this.sqlEvent.toString());
        System.err.println("sqlFirewallManager : " + this.sqlFirewallManager.getClass().getName());
        e.printStackTrace();
    }

    public void onSuccess(SqlInjectionDetectionResult result, int statusCode, Map<String, List<String>> responseHeaders) {
        long begin = System.currentTimeMillis();
        this.debug("onSucces: result.isContainedSqlInjectionAttack():" + result.isContainedSqlInjectionAttack());
        if (!result.isContainedSqlInjectionAttack().booleanValue()) {
            return;
        }
        this.debug("Loading DatabaseConfigurator...");
        String database = this.sqlEvent.getDatabase();
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        Connection connection = null;
        try {
            try {
                this.debug("Connection creation...");
                connection = databaseConfigurator.getConnection(database);
                this.debug("Running SqlFirewallTriggers runIfStatementRefused: " + this.sqlEvent + "  " + this.sqlFirewallManager.getClass().getSimpleName());
                SqlFirewallTriggerWrapper.runIfStatementRefused(this.sqlEvent, this.sqlFirewallManager, connection);
                long end = System.currentTimeMillis();
                this.debug("Running SqlFirewallTriggers done! (" + (end - begin) + "ms.)");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (connection != null) {
                        databaseConfigurator.close(connection);
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (connection != null) {
                    databaseConfigurator.close(connection);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
    }

    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(new Date() + " " + this.getClass().getSimpleName() + " " + string);
        }
    }
}

